package com.tbyf.his.system.service;

import com.tbyf.his.system.domain.SysBjgColumn;

import java.util.List;

/**
 * 结构_列说明Service接口
 *
 * @author guopx
 * @date 2022-05-12
 */
public interface ISysBjgColumnService {
    /**
     * 查询结构_列说明
     *
     * @param tabName 结构_列说明主键
     * @return 结构_列说明
     */
    public List<SysBjgColumn> selectSysBjgColumnByTabName(String tabName);

    /**
     * 模糊查询
     *
     * @param sysBjgColumn
     * @return
     */
    public List<SysBjgColumn> likeSelectSysBjgColumn(SysBjgColumn sysBjgColumn);

    /**
     * 查询结构_列说明列表
     *
     * @param sysBjgColumn 结构_列说明
     * @return 结构_列说明集合
     */
    public List<SysBjgColumn> selectSysBjgColumnList(SysBjgColumn sysBjgColumn);


    /**
     * 新增结构_列说明
     *
     * @param sysBjgColumn 结构_列说明
     * @return 结果
     */
    public int insertSysBjgColumn(SysBjgColumn sysBjgColumn);

    /**
     * 修改结构_列说明
     *
     * @param sysBjgColumn 结构_列说明
     * @return 结果
     */
    public int updateSysBjgColumn(SysBjgColumn sysBjgColumn);

    /**
     * 批量删除结构_列说明
     *
     * @param tabNames 需要删除的结构_列说明主键集合
     * @return 结果
     */
    public int deleteSysBjgColumnByTabNames(String[] tabNames);

    /**
     * 删除结构_列说明信息
     *
     * @param tabName 结构_列说明主键
     * @return 结果
     */
    public int deleteSysBjgColumnByTabName(String tabName);
}
