package com.tbyf.his.system.service.impl;

import com.tbyf.his.system.domain.SysDictShowhidecolumn;
import com.tbyf.his.system.mapper.SysDictShowhidecolumnMapper;
import com.tbyf.his.system.service.ISysDictShowhidecolumnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 字典显隐藏操作Service业务层处理
 *
 * @author guopx
 * @date 2022-03-25
 */
@Service
public class SysDictShowhidecolumnServiceImpl implements ISysDictShowhidecolumnService {
    @Autowired
    private SysDictShowhidecolumnMapper sysDictShowhidecolumnMapper;

    /**
     * 查询字典显隐藏操作
     *
     * @param id 字典显隐藏操作主键
     * @return 字典显隐藏操作
     */
    @Override
    public SysDictShowhidecolumn selectSysDictShowhidecolumnById(Long id) {
        return sysDictShowhidecolumnMapper.selectSysDictShowhidecolumnById(id);
    }

    /**
     * 查询字典显隐藏操作列表
     *
     * @param sysDictShowhidecolumn 字典显隐藏操作
     * @return 字典显隐藏操作
     */
    @Override
    public List<SysDictShowhidecolumn> selectSysDictShowhidecolumnList(SysDictShowhidecolumn sysDictShowhidecolumn) {
        return sysDictShowhidecolumnMapper.selectSysDictShowhidecolumnList(sysDictShowhidecolumn);
    }

    /**
     * 新增字典显隐藏操作
     *
     * @param sysDictShowhidecolumn 字典显隐藏操作
     * @return 结果
     */
    @Override
    public int insertSysDictShowhidecolumn(SysDictShowhidecolumn sysDictShowhidecolumn) {
        return sysDictShowhidecolumnMapper.insertSysDictShowhidecolumn(sysDictShowhidecolumn);
    }

    /**
     * 修改字典显隐藏操作
     *
     * @param sysDictShowhidecolumn 字典显隐藏操作
     * @return 结果
     */
    @Override
    public int updateSysDictShowhidecolumn(SysDictShowhidecolumn sysDictShowhidecolumn) {
        return sysDictShowhidecolumnMapper.updateSysDictShowhidecolumn(sysDictShowhidecolumn);
    }

    /**
     * 批量删除字典显隐藏操作
     *
     * @param ids 需要删除的字典显隐藏操作主键
     * @return 结果
     */
    @Override
    public int deleteSysDictShowhidecolumnByIds(Long[] ids) {
        return sysDictShowhidecolumnMapper.deleteSysDictShowhidecolumnByIds(ids);
    }

    /**
     * 删除字典显隐藏操作信息
     *
     * @param id 字典显隐藏操作主键
     * @return 结果
     */
    @Override
    public int deleteSysDictShowhidecolumnById(Long id) {
        return sysDictShowhidecolumnMapper.deleteSysDictShowhidecolumnById(id);
    }
}
