package com.tbyf.his.web.dataImport.domain.vo;

import com.tbyf.his.web.dataImport.core.RuleVO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 校验模型
 *
 * @author lzz
 * @date 2023/2/12 21:20
 */

@Data
@Accessors(chain = true)
public class VerifyVO {

    @ApiModelProperty(value = "字段ID")
    private String fieldId;

    @ApiModelProperty(value = "代码")
    private String code;

    @ApiModelProperty(value = "指标名称")
    private String title;

    @ApiModelProperty(value = "计量单位")
    private String unit;

    @ApiModelProperty(value = "数据起始坐标,例如 C,4")
    private String coordinate;

    @ApiModelProperty(value = "排序字段")
    private Integer sort;

    @ApiModelProperty(value = "元字段ID")
    private String metaFieldId;

    @ApiModelProperty(value = "数据库字段名")
    private String fieldName;

    @ApiModelProperty(value = "数据库字段类型")
    private String fieldType;

    @ApiModelProperty(value = "待校验的值列表")
    private List<String> values;

    @ApiModelProperty(value = "校验规则列表")
    private List<RuleVO> rules;

    @ApiModelProperty(value = "错误结果列表")
    private List<ExcelVO> errors;

    public VerifyVO addValue(String value) {
        if (CollectionUtils.isEmpty(values)) {
            values = new ArrayList<>();
        }
        values.add(value);
        return this;
    }

    public VerifyVO addError(ExcelVO error) {
        if (CollectionUtils.isEmpty(errors)) {
            errors = new ArrayList<>();
        }
        errors.add(error);
        return this;
    }

}
