package com.tbyf.his.web.dataImport.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@ApiModel(value = "修改字段", description = "修改字段")
public class UpdateFieldParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字段ID")
    @NotBlank(message = "字段ID不能为空")
    private String id;

    @ApiModelProperty(value = "代码")
    private String code;

    @ApiModelProperty(value = "指标名称")
    private String title;

    @ApiModelProperty(value = "计量单位")
    private String unit;

    @ApiModelProperty(value = "数据起始坐标")
    private String coordinate;

    @ApiModelProperty(value = "排序字段")
    private Integer sort;

    @ApiModelProperty(value = "数据库字段名")
    private String field;

}
