package com.tbyf.his.web.dataImport.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@ApiModel(value = "修改字段", description = "修改字段")
public class UpdateRuleParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "规则id")
    @NotBlank(message = "规则id不能为空")
    private String id;

    @ApiModelProperty(value = "规则名称")
    private String name;

    @ApiModelProperty(value = "规则类型 1-基础规则 2-组合规则 3-字段复合规则")
    private String type;

    @ApiModelProperty(value = "规则验证模式")
    private String mode;

    @ApiModelProperty(value = "规则验证内容")
    private String content;

    @ApiModelProperty(value = "备注")
    private String remarks;

}
