package com.tbyf.his.system.service.impl;

import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.system.domain.SysBjgColumn;
import com.tbyf.his.system.mapper.SysBjgColumnMapper;
import com.tbyf.his.system.service.ISysBjgColumnService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 结构_列说明Service业务层处理
 *
 * @author guopx
 * @date 2022-05-12
 */
@DataSource(value = DataSourceType.SLAVE)
@Service
public class SysBjgColumnServiceImpl implements ISysBjgColumnService {
    @Autowired
    private SysBjgColumnMapper sysBjgColumnMapper;

    /**
     * 查询结构_列说明
     *
     * @param tabName 结构_列说明主键
     * @return 结构_列说明
     */
    @Override
    public List<SysBjgColumn> selectSysBjgColumnByTabName(String tabName) {

        return sysBjgColumnMapper.selectSysBjgColumnByTabName(tabName);
    }

    /**
     * 模糊查询
     *
     * @param sysBjgColumn
     * @return
     */
    @Override
    public List<SysBjgColumn> likeSelectSysBjgColumn(SysBjgColumn sysBjgColumn) {
        return sysBjgColumnMapper.likeSelectSysBjgColumn(sysBjgColumn);
    }

    /**
     * 查询结构_列说明列表
     *
     * @param sysBjgColumn 结构_列说明
     * @return 结构_列说明
     */
    @Override
    public List<SysBjgColumn> selectSysBjgColumnList(SysBjgColumn sysBjgColumn) {
        DataSourceUtil.switchDs("jdbc:oracle:thin:@192.168.0.39:1521:orcl", "oracle.jdbc.OracleDriver", "SA", "sa", "SA");
        return sysBjgColumnMapper.selectSysBjgColumnList(sysBjgColumn);
    }


    /**
     * 新增结构_列说明
     *
     * @param sysBjgColumn 结构_列说明
     * @return 结果
     */
    @Override
    public int insertSysBjgColumn(SysBjgColumn sysBjgColumn) {
        return sysBjgColumnMapper.insertSysBjgColumn(sysBjgColumn);
    }

    /**
     * 修改结构_列说明
     *
     * @param sysBjgColumn 结构_列说明
     * @return 结果
     */
    @Override
    public int updateSysBjgColumn(SysBjgColumn sysBjgColumn) {
        return sysBjgColumnMapper.updateSysBjgColumn(sysBjgColumn);
    }

    /**
     * 批量删除结构_列说明
     *
     * @param tabNames 需要删除的结构_列说明主键
     * @return 结果
     */
    @Override
    public int deleteSysBjgColumnByTabNames(String[] tabNames) {
        return sysBjgColumnMapper.deleteSysBjgColumnByTabNames(tabNames);
    }

    /**
     * 删除结构_列说明信息
     *
     * @param tabName 结构_列说明主键
     * @return 结果
     */
    @Override
    public int deleteSysBjgColumnByTabName(String tabName) {
        return sysBjgColumnMapper.deleteSysBjgColumnByTabName(tabName);
    }
}
