package com.tbyf.his.web.controller.dataImport;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tbyf.his.common.annotation.IgnoreWebSecurity;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.exception.base.BaseException;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.DataImportUtils;
import com.tbyf.his.web.dataImport.core.DiConfig;
import com.tbyf.his.web.dataImport.domain.param.UploadExcelParam;
import com.tbyf.his.web.dataImport.domain.vo.AreaDict;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import com.tbyf.his.web.dataImport.entity.DataDict;
import com.tbyf.his.web.dataImport.entity.DataTemplate;
import com.tbyf.his.web.dataImport.entity.ExcelData;
import com.tbyf.his.web.dataImport.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/2/16 15:30
 */
@RestController
@Api(tags = "excel文件接口")
@RequestMapping("/data/excel")
@Slf4j
public class ExcelDataController {

    @Autowired
    private ExcelDataService excelDataService;

    @Autowired
    private DataTemplateService dataTemplateService;

    @Autowired
    private DataFieldService dataFieldService;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private DataDictService dataDictService;

    @IgnoreWebSecurity
    @GetMapping("/download/template")
    @ApiOperation("模板下载")
    public void downloadTemplate(HttpServletResponse response,
                                 @RequestParam String excelId) {
        final ExcelData excel = excelDataService.getById(excelId);
        if (excel != null) {
            try (OutputStream os = response.getOutputStream()) {
                os.write(excel.getFile());
                os.flush();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @IgnoreWebSecurity
    @GetMapping("/download/template/filename")
    @ApiOperation("获取模板文件名")
    public AjaxResult getTemplateFileName(@RequestParam String excelId) {
        final ExcelData excel = excelDataService.getOne(
                Wrappers.lambdaQuery(ExcelData.class)
                        .select(ExcelData::getFileName)
                        .eq(ExcelData::getId, excelId)
        );
        if (excel != null) {
            return AjaxResult.success(excel);
        } else {
            return AjaxResult.error("未查询到指定的模板文件");
        }
    }

    @SneakyThrows
    @IgnoreWebSecurity
    @PostMapping("/upload")
    //@Transactional(rollbackFor = Exception.class)
    @ApiOperation("文件导入")
    public AjaxResult bindRule(UploadExcelParam param) {
        if (StringUtils.equals(param.getType(), "1")) {
            ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                    .eq(ExcelData::getTemplateId, param.getTemplateId())
                    .eq(ExcelData::getType, "1"), false);
            if (excelData == null) {
                excelData = new ExcelData();
                excelData.setType("1");
                excelData.setTemplateId(param.getTemplateId());
                excelData.setYear(param.getYear());
                excelData.setOrgName(param.getOrgName());
            }
            excelData.setFile(param.getFile().getBytes());
            excelData.setFileName(param.getFile().getOriginalFilename());
            // 保存后导入文件数据
            excelDataService.importData(excelData);
            excelDataService.saveOrUpdate(excelData);
        } else if (StringUtils.equals(param.getType(), "2")) {
            ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                    .eq(ExcelData::getTemplateId, param.getTemplateId())
                    .eq(ExcelData::getType, "2"), false);
            if (ObjectUtils.isEmpty(excelData)) {
                excelData = new ExcelData();
                excelData.setFile(param.getFile().getBytes());
                excelData.setFileName(param.getFile().getOriginalFilename());
                excelData.setType("2");
                excelData.setTemplateId(param.getTemplateId());
                excelData.setYear(param.getYear());
                excelData.setOrgName(param.getOrgName());
                excelDataService.save(excelData);
            } else {
                excelData.setFile(param.getFile().getBytes());
                excelData.setFileName(param.getFile().getOriginalFilename());
                excelDataService.updateById(excelData);
            }
        }
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/queryArea")
    @ApiOperation("获取机构数据")
    public AjaxResult queryArea(@RequestParam String name, @RequestParam String year, @RequestParam String type) {
        ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                .eq(ExcelData::getOrgName, name)
                .eq(ExcelData::getYear, year)
                .eq(ExcelData::getType, "1"), false);
        if (excelData == null) {
            return AjaxResult.error("请先上传数据并分析");
        }
        final List<DataDict> areaList = dataDictService.list(Wrappers.lambdaQuery(DataDict.class)
                .eq(DataDict::getType, "area"));
        DataTemplate template = dataTemplateService.getById(excelData.getTemplateId());
        String sql = "SELECT ROWCODE, '{}' AS ORG_TYPE,ORG_NAME,MAILING_ADDRESS,AREA_NUMBER_CODE FROM {} WHERE YEAROOFDATARECORD='{}年'";
        try {
            DataSourceService.switchDb(template.getDataSourceId());
            List<AreaDict> areaDictList = jdbcTemplate.query(
                    StrFormatter.format(sql, template.getOrgName(), template.getTableName() + "_TEMP", template.getYear()),
                    new BeanPropertyRowMapper<>(AreaDict.class));
            DataSourceService.switchDefault();
            // 错误数据筛选
            if (StringUtils.equals(type, "0")) {
                areaDictList = areaDictList.stream()
                        .filter(area -> {
                            if (StringUtils.isBlank(area.getAREA_NUMBER_CODE())) {
                                return true;
                            }
                            if (StringUtils.isBlank(area.getORG_NAME())) {
                                return true;
                            }
                            final Optional<DataDict> first = areaList.stream().filter(item -> StringUtils.equals(item.getValue(), area.getAREA_NUMBER_CODE())).findFirst();
                            return !first.map(dataDict -> area.getORG_NAME().startsWith(dataDict.getLabel())).orElse(true);
                        })
                        .collect(Collectors.toList());
            }
            return AjaxResult.success(areaDictList);
        } finally {
            DataSourceService.switchDefault();
        }
    }


    @IgnoreWebSecurity
    @PostMapping("/updateArea")
    @ApiOperation("更新机构数据")
    public AjaxResult updateArea(@RequestBody AreaDict area) {
        String sql = "UPDATE {} SET ORG_NAME = '{}' ,MAILING_ADDRESS='{}',AREA_NUMBER_CODE='{}' WHERE ROWCODE = '{}'";
        ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                .eq(ExcelData::getOrgName, area.getName())
                .eq(ExcelData::getYear, area.getYear())
                .eq(ExcelData::getType, "1"), false);
        DataTemplate template = dataTemplateService.getById(excelData.getTemplateId());
        try {
            DataSourceService.switchDb(template.getDataSourceId());
            jdbcTemplate.execute(StrFormatter.format(sql,
                    template.getTableName() + "_TEMP",
                    DataImportUtils.str(area.getORG_NAME()),
                    DataImportUtils.str(area.getMAILING_ADDRESS()),
                    DataImportUtils.str(area.getAREA_NUMBER_CODE()),
                    DataImportUtils.str(area.getROWCODE())));
            return AjaxResult.success();
        } finally {
            DataSourceService.switchDefault();
        }
    }

    @IgnoreWebSecurity
    @GetMapping("/export")
    @ApiOperation("excel导出")
    public void queryArea(@RequestParam String name, @RequestParam String year, HttpServletResponse response) {
        ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                .eq(ExcelData::getOrgName, name)
                .eq(ExcelData::getYear, year)
                .eq(ExcelData::getType, "1"), false);
        DataTemplate template = dataTemplateService.getById(excelData.getTemplateId());
        // 查询每个指定的字段在第几行
        List<VerifyVO> verifyVOList = dataFieldService.getFieldsInfo(Arrays.asList("ORG_CODE", "ORG_NAME", "MAILING_ADDRESS", "AREA_NUMBER_CODE"), template.getId());
        Map<String, String> fieldMap = new HashMap<>();
        verifyVOList.forEach(item -> fieldMap.put(item.getFieldName(), item.getCoordinate()));
        final String orgCodeCo = fieldMap.get("ORG_CODE");
        if (StringUtils.isBlank(orgCodeCo)) {
            return;
        }
        final int rowStart = Integer.parseInt(orgCodeCo.split(",")[1]);
        try (InputStream is = new ByteArrayInputStream(excelData.getFile()); Workbook workbook = WorkbookFactory.create(is)) {
            final Sheet sheet = workbook.getSheetAt(0);
            String sql = "SELECT ORG_CODE,ORG_NAME,MAILING_ADDRESS,AREA_NUMBER_CODE FROM {} WHERE YEAROOFDATARECORD='{}年' ORDER BY ROWCODE";
            try {
                DataSourceService.switchDb(template.getDataSourceId());
                final List<Map<String, Object>> mapList = jdbcTemplate.queryForList(
                        StrFormatter.format(sql, template.getTableName() + "_TEMP", template.getYear()));
                root:
                for (Map<String, Object> map : mapList) {
                    final Row row = sheet.getRow(rowStart - 1);
                    for (Cell cell : row) {
                        if (StringUtils.equals(DiConfig.getValue(cell), String.valueOf(map.get("ORG_CODE")))) {
                            // 确定纵坐标直接赋值
                            final int columnIndex = cell.getColumnIndex();
                            Arrays.asList("ORG_NAME", "MAILING_ADDRESS", "AREA_NUMBER_CODE").forEach(item -> {
                                final String coordinate = fieldMap.get(item);
                                if (StringUtils.isNotBlank(coordinate)) {
                                    final int rowIndex = Integer.parseInt(coordinate.split(",")[1]);
                                    Cell tempCell = sheet.getRow(rowIndex - 1).getCell(columnIndex);
                                    if (tempCell == null) {
                                        tempCell = sheet.getRow(rowIndex - 1).createCell(columnIndex);
                                    }
                                    tempCell.setCellValue(DataImportUtils.str(map.get(item)));
                                }
                            });
                            continue root;
                        }
                    }
                }
                workbook.write(response.getOutputStream());
            } finally {
                DataSourceService.switchDefault();
            }
        } catch (IOException e) {
            throw new BaseException(e.getMessage());
        }
    }


}
