package com.tbyf.his.web.dataImport.domain.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@ApiModel(value = "新增字段", description = "新增字段")
public class AddFieldParam implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "模板ID")
    @NotBlank(message = "模板ID不能为空")
    private String templateId;

    @ApiModelProperty(value = "代码")
    private String code;

    @ApiModelProperty(value = "指标名称")
    @NotBlank(message = "指标名称不能为空")
    private String title;

    @ApiModelProperty(value = "计量单位")
    private String unit;

    @ApiModelProperty(value = "数据起始坐标")
    @NotBlank(message = "数据起始坐标不能为空")
    private String coordinate;

    @ApiModelProperty(value = "排序字段")
    private Integer sort = 0;

    @ApiModelProperty(value = "数据库字段名")
    private String field;

}
