package com.tbyf.his.apiconvert.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 参数配置对象 apiconvert_baseinfo
 *
 * @author guopx
 * @date 2022-03-01
 */
public class ApiconvertBaseinfo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 接口id
     */
    private Long apiId;

    /**
     * 接口名称
     */
    @Excel(name = "接口名称")
    private String apiName;

    /**
     * 模糊查询条件
     */
    @Excel(name = "模糊查询条件")
    private String apiCode;

    /**
     * 接口地址
     */
    @Excel(name = "接口地址")
    private String apiUrl;

    /**
     * 源消息协议
     */
    @Excel(name = "源消息协议")
    private String sourceProtocol;

    /**
     * 源消息格式
     */
    @Excel(name = "源消息格式")
    private String sourceFormat;

    /**
     * 源认证信息
     */
    @Excel(name = "源认证信息")
    private String sourceAuth;

    /**
     * 目标接口地址
     */
    @Excel(name = "目标接口地址")
    private String targetUrl;

    /**
     * 目标消息格式
     */
    @Excel(name = "目标消息格式")
    private String targetFormat;

    /**
     * 目标消息协议
     */
    @Excel(name = "目标消息协议")
    private String targetProtocol;
    private String targetSqltext;
    private String targetDatasource;
    private String datasourceGroup;
    private String targetDataStruct;

    private Long moduleId;

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public String getTargetDataStruct() {
        return targetDataStruct;
    }

    public void setTargetDataStruct(String targetDataStruct) {
        this.targetDataStruct = targetDataStruct;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getSourceAuth() {
        return sourceAuth;
    }

    public void setSourceAuth(String sourceAuth) {
        this.sourceAuth = sourceAuth;
    }

    /**
     * 目标认证信息
     */
    @Excel(name = "目标认证信息")
    private String targetAuth;

    public void setApiId(Long apiId) {
        this.apiId = apiId;
    }

    public Long getApiId() {
        return apiId;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getApiCode() {
        return apiCode;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public String getApiName() {
        return apiName;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiUrl() {
        return apiUrl;
    }

    public void setSourceProtocol(String sourceProtocol) {
        this.sourceProtocol = sourceProtocol;
    }

    public String getSourceProtocol() {
        return sourceProtocol;
    }

    public void setSourceFormat(String sourceFormat) {
        this.sourceFormat = sourceFormat;
    }

    public String getSourceFormat() {
        return sourceFormat;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public String getTargetUrl() {
        return targetUrl;
    }

    public void setTargetFormat(String targetFormat) {
        this.targetFormat = targetFormat;
    }

    public String getTargetFormat() {
        return targetFormat;
    }

    public void setTargetProtocol(String targetProtocol) {
        this.targetProtocol = targetProtocol;
    }

    public String getTargetProtocol() {
        return targetProtocol;
    }

    public void setTargetSqltext(String targetSqltext) {
        this.targetSqltext = targetSqltext;
    }

    public String getTargetSqltext() {
        return targetSqltext;
    }

    public void setTargetDatasource(String targetDatasource) {
        this.targetDatasource = targetDatasource;
    }

    public String getTargetDatasource() {
        return targetDatasource;
    }

    public String getDatasourceGroup() {
        return datasourceGroup;
    }

    public void setDatasourceGroup(String datasourceGroup) {
        this.datasourceGroup = datasourceGroup;
    }

    public void setTargetAuth(String targetAuth) {
        this.targetAuth = targetAuth;
    }

    public String getTargetAuth() {
        return targetAuth;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("apiId", getApiId())
                .append("apiCode", getApiCode())
                .append("apiName", getApiName())
                .append("apiUrl", getApiUrl())
                .append("sourceProtocol", getSourceProtocol())
                .append("sourceFormat", getSourceFormat())
                .append("sourceAhth", getSourceAuth())
                .append("targetUrl", getTargetUrl())
                .append("targetFormat", getTargetFormat())
                .append("targetProtocol", getTargetProtocol())
                .append("targetSqltext", getTargetSqltext())
                .append("datasourceGroup", getDatasourceGroup())
                .append("targetDataSource", getTargetDatasource())
                .append("targetAuth", getTargetAuth())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("remark", getRemark())
                .append("moduleId", getModuleId())
                .toString();
    }
}
