package com.tbyf.his.web.controller.apiconvert;

import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.domain.ApiconvertBaseinfo;
import com.tbyf.his.apiconvert.domain.ExecuteApi;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.common.utils.sign.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;

/**
 * 参数配置Controller
 *
 * @author guopx
 * @date 2022-03-01
 */
@RestController
@RequestMapping("/system/baseinfo")
public class ApiconvertBaseinfoController extends BaseController {
    @Autowired
    private IApiconvertBaseinfoService apiconvertBaseinfoService;

    /**
     * 查询参数配置列表
     */
    @PreAuthorize("@ss.hasPermi('apiconvert:baseinfo:list')")
    @GetMapping("/list")
    public TableDataInfo list(ApiconvertBaseinfo apiconvertBaseinfo) {
        startPage();
        List<ApiconvertBaseinfo> list = apiconvertBaseinfoService.selectApiconvertBaseinfoList(apiconvertBaseinfo);
        return getDataTable(list);
    }

    /**
     * 导出参数配置列表
     */
    @PreAuthorize("@ss.hasPermi('apiconvert:baseinfo:export')")
    @Log(title = "参数配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, ApiconvertBaseinfo apiconvertBaseinfo) {
        List<ApiconvertBaseinfo> list = apiconvertBaseinfoService.selectApiconvertBaseinfoList(apiconvertBaseinfo);
        ExcelUtil<ApiconvertBaseinfo> util = new ExcelUtil<ApiconvertBaseinfo>(ApiconvertBaseinfo.class);
        util.exportExcel(response, list, "参数配置数据");
    }

    /**
     * 获取参数配置详细信息
     */
    @PreAuthorize("@ss.hasPermi('apiconvert:baseinfo:query')")
    @GetMapping(value = "/{apiId}")
    public AjaxResult getInfo(@PathVariable("apiId") Long apiId) {
        ApiconvertBaseinfo apiconvertBaseinfo = apiconvertBaseinfoService.selectApiconvertBaseinfoByApiId(apiId);
        String sqlText = apiconvertBaseinfo.getTargetSqltext();
        if (Base64.decode(sqlText) != null) {
            apiconvertBaseinfo.setTargetSqltext(Base64.decode(sqlText));
        }
        return AjaxResult.success(apiconvertBaseinfo);
    }

    /**
     * 新增参数配置
     */
    @PreAuthorize("@ss.hasPermi('apiconvert:baseinfo:add')")
    @Log(title = "参数配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ApiconvertBaseinfo apiconvertBaseinfo) throws UnsupportedEncodingException {
        return toAjax(apiconvertBaseinfoService.insertApiconvertBaseinfo(apiconvertBaseinfo));
    }

    /**
     * 修改参数配置
     */
    @PreAuthorize("@ss.hasPermi('apiconvert:baseinfo:edit')")
    @Log(title = "参数配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ApiconvertBaseinfo apiconvertBaseinfo) throws UnsupportedEncodingException {
        return toAjax(apiconvertBaseinfoService.updateApiconvertBaseinfo(apiconvertBaseinfo));
    }

    /**
     * 删除参数配置
     */
    @PreAuthorize("@ss.hasPermi('apiconvert:baseinfo:remove')")
    @Log(title = "参数配置", businessType = BusinessType.DELETE)
    @DeleteMapping("/{apiIds}")
    public AjaxResult remove(@PathVariable Long[] apiIds) {
        return toAjax(apiconvertBaseinfoService.deleteApiconvertBaseinfoByApiIds(apiIds));
    }


    //@ApiOperation("sqlSelect")
    @PostMapping("/sqlSelect/{apiId}")
    public AjaxResult sqlSelect(@PathVariable Long apiId, @RequestBody JSONObject params) {
        ApiconvertBaseinfo apiconvertBaseinfo = apiconvertBaseinfoService.selectApiconvertBaseinfoByApiId(apiId);
        Object jsonObjects = apiconvertBaseinfoService.executeApi(apiconvertBaseinfo, params);
        return AjaxResult.success(jsonObjects);
    }

    @GetMapping("/getOptionByName")
    public AjaxResult getOptionByName(String apiName) {
        List<MyKeyValue> list = apiconvertBaseinfoService.getOptionByName(apiName);
        return AjaxResult.success(list);
    }

    @PostMapping("/executeApi")
    public AjaxResult executeApi(@RequestBody ExecuteApi executeApi) {
        List<JSONObject> jsonObjects = apiconvertBaseinfoService.executeApi(executeApi.getApiId(), executeApi.getParams());
        return AjaxResult.success(jsonObjects);
    }

}
