package com.tbyf.his.web.controller.publish;

import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.platform.domain.PfIdLabel;
import com.tbyf.his.platform.service.IPMPubliserviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 同步消息配置Controller
 *
 * @author guopx
 * @date 2020-11-05
 */
@RestController
@RequestMapping("/platform/syncSeting")
public class PMSyncsettingController extends BaseController {

    @Autowired
    private IPMPubliserviewService pMPubliserviewService;


    /**
     * 查询发布者列表
     */
    @GetMapping("/publisher")
    public AjaxResult publisherTree() {
        List<PfIdLabel> list = pMPubliserviewService.selectPublisherTree();
        return AjaxResult.success(list);
    }

    /**
     * 查询发布数据集列表
     */
    @GetMapping("/pubDataSets/{publisercode}")
    public AjaxResult pubDataSets(@PathVariable String publisercode) {
        return AjaxResult.success(pMPubliserviewService.selectDataSetsByPub(publisercode));
    }

}
