package com.tbyf.his.web.core.config;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.framework.config.MyBatisConfig;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

import javax.sql.DataSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * mybatis_plus适配整合
 *
 * @author lzz
 * @date 2023/1/10 16:48
 */
@Configuration
public class MybatisPlusWrapperConfig {


    /**
     * 分页插件
     * 乐观锁插件 字段上加入@Version注解 仅支持 updateById(id) 与 update(entity, wrapper) 方法
     * 防全表更新与删除插件
     */
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        OptimisticLockerInnerInterceptor optimisticLockerInnerInterceptor = new OptimisticLockerInnerInterceptor();
        BlockAttackInnerInterceptor blockAttackInnerInterceptor = new BlockAttackInnerInterceptor();
        interceptor.addInnerInterceptor(paginationInnerInterceptor);
        interceptor.addInnerInterceptor(optimisticLockerInnerInterceptor);
        interceptor.addInnerInterceptor(blockAttackInnerInterceptor);
        return interceptor;
    }

    @Autowired
    private Environment env;

    public Resource[] resolveMapperLocations(String[] mapperLocations) {
        ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        List<Resource> resources = new ArrayList<Resource>();
        if (mapperLocations != null) {
            for (String mapperLocation : mapperLocations) {
                try {
                    Resource[] mappers = resourceResolver.getResources(mapperLocation);
                    resources.addAll(Arrays.asList(mappers));
                } catch (IOException e) {
                    // ignore
                }
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    /**
     * 整合mp,覆盖默认的sqlSessionFactory
     *
     * @param dataSource
     * @return
     * @throws Exception
     */
    @Primary
    @Bean("db1SqlSessionFactory")
    public SqlSessionFactory mpSqlSessionFactory(DataSource dataSource, MybatisPlusInterceptor interceptor) throws Exception {
        String typeAliasesPackage = env.getProperty("mybatis.typeAliasesPackage");
        String mapperLocations = env.getProperty("mybatis.mapperLocations");
        String configLocation = env.getProperty("mybatis.configLocation");
        typeAliasesPackage = MyBatisConfig.setTypeAliasesPackage(typeAliasesPackage);
        VFS.addImplClass(SpringBootVFS.class);

        MybatisSqlSessionFactoryBean b1 = new MybatisSqlSessionFactoryBean();
        b1.setDataSource(dataSource);
        b1.setTypeAliasesPackage(typeAliasesPackage);
        b1.setMapperLocations(resolveMapperLocations(StringUtils.split(mapperLocations, ",")));
        b1.setConfigLocation(new DefaultResourceLoader().getResource(configLocation));
        final SqlSessionFactory sessionFactory = b1.getObject();
        sessionFactory.getConfiguration().addInterceptor(interceptor);
        return sessionFactory;
    }

}
