package com.tbyf.his.web.dataImport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.core.DiConfig;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.RuleValidator;
import com.tbyf.his.web.dataImport.entity.DataRule;
import com.tbyf.his.web.dataImport.service.DataRuleService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 组合规则 逻辑或校验
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(DiConstants.SERVICE_PREFIX + DiConstants.VALID_MODE_OR)
@Slf4j
public class OrValidator implements RuleValidator {

    @Autowired
    private DataRuleService dataRuleService;

    @Override
    public void validate(RuleVO rule) {
        try {
            if (StringUtils.isNotBlank(rule.getContent())) {
                final String[] ruleIds = rule.getContent().split(DiConstants.SEPARATOR);
                final DataRule dataRule1 = dataRuleService.getById(ruleIds[0]);
                final DataRule dataRule2 = dataRuleService.getById(ruleIds[1]);
                final RuleVO rule1 = RuleVO.create(dataRule1);
                final RuleVO rule2 = RuleVO.create(dataRule2);
                rule1.setValue(rule.getValue());
                rule2.setValue(rule.getValue());
                final RuleValidator validator1 = DiConfig.getValidator(rule1.getMode());
                validator1.validate(rule1);
                if (StringUtils.isNotBlank(rule1.getResult())) {
                    // 第一个条件不满足就进行第二个
                    final RuleValidator validator2 = DiConfig.getValidator(rule2.getMode());
                    validator2.validate(rule2);
                    if (StringUtils.isNotBlank(rule2.getResult())) {
                        rule.setResult(rule2.getResult());
                    }
                }
            }
        } catch (Exception e) {
            log.error("逻辑或组合校验未通过", e);
            //rule.setResult(StringUtils.format("逻辑或组合校验未通过"));
        }
    }
}
