package com.tbyf.his.job.obj;

import com.tbyf.his.common.exception.ServiceException;

/**
 * @author: fr
 * @date: 2022年07月25日 15:05
 */
public enum JobEnum {
    /**
     * 执行本地方法
     */
    EXECUTE_METHOD(0),
    /**
     * 执行接口
     */
    EXECUTE_INTERFACE(1),
    /**
     * 执行sql
     */
    EXECUTE_SQL(2),
    /**
     * 执行jar包
     */
    EXECUTE_JAR(3);

    public int type;

    JobEnum(int type) {
        this.type = type;
    }

    public static JobEnum getByType(int type) {
        for (JobEnum e : JobEnum.values()) {
            if (e.type == type) {
                return e;
            }
        }
        throw new ServiceException("不合法的执行类型" + type);
    }
}
