package com.tbyf.his.print.domain;


import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.Map;

/**
 * 打印模板项对象 print_temp_item
 *
 * @author x
 * @date 2022-02-28
 */
public class PrintTempItem extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    private Long id;

    /**
     * 默认数据
     */
    @Excel(name = "默认数据")
    private String defaultValue;

    /**
     * 可拖动
     */
    @Excel(name = "可拖动")
    private String dragable2str;
    private Boolean dragable;

    /**
     * 高度
     */
    @Excel(name = "高度")
    private BigDecimal height;

    /**
     * 可编辑
     */
    @Excel(name = "可编辑")
    private Long isEdit;

    /**
     * 左边距
     */
    @Excel(name = "左边距")
    private BigDecimal left;

    /**
     * lodopStyle
     */
    @Excel(name = "lodopStyle")
    private String lodopStyle2str;
    private Map<String, Object> lodopStyle;

    /**
     * 名称
     */
    @Excel(name = "名称")
    private String name;

    public Boolean getDragable() {
        return dragable;
    }

    public void setDragable(Boolean dragable) {
        this.dragable = dragable;
    }

    public Map<String, Object> getLodopStyle() {
        return lodopStyle;
    }

    public void setLodopStyle(Map<String, Object> lodopStyle) {
        this.lodopStyle = lodopStyle;
    }

    public Boolean getResizable() {
        return resizable;
    }

    public void setResizable(Boolean resizable) {
        this.resizable = resizable;
    }

    public Map<String, Object> getStyle() {
        return style;
    }

    public void setStyle(Map<String, Object> style) {
        this.style = style;
    }

    /**
     * 大小可变
     */
    @Excel(name = "大小可变")
    private String resizable2str;
    private boolean resizable;

    /**
     * 样式
     */
    private String style2str;
    private Map<String, Object> style;
    /**
     * 标题
     */
    @Excel(name = "标题")
    private String title;

    /**
     * top
     */
    @Excel(name = "top")
    private BigDecimal top;

    /**
     * 打印类型
     */
    @Excel(name = "打印类型")
    private String type;

    /**
     * uuid
     */
    @Excel(name = "uuid")
    private String uuid;

    /**
     * 数据绑定
     */
    @Excel(name = "数据绑定")
    private String value;

    /**
     * 宽度
     */
    @Excel(name = "宽度")
    private BigDecimal width;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private Long tempId;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDragable2str(String dragable2str) {
        this.dragable2str = dragable2str;
    }

    public String getDragable2str() {
        return dragable2str;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public void setIsEdit(Long isEdit) {
        this.isEdit = isEdit;
    }

    public Long getIsEdit() {
        return isEdit;
    }

    public void setLeft(BigDecimal left) {
        this.left = left;
    }

    public BigDecimal getLeft() {
        return left;
    }

    public void setLodopStyle2str(String lodopStyle2str) {
        this.lodopStyle2str = lodopStyle2str;
    }

    public String getLodopStyle2str() {
        return lodopStyle2str;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setResizable2str(String resizable2str) {
        this.resizable2str = resizable2str;
    }

    public String getResizable2str() {
        return resizable2str;
    }

    public void setStyle2str(String style2str) {
        this.style2str = style2str;
    }

    public String getStyle2str() {
        return style2str;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return title;
    }

    public void setTop(BigDecimal top) {
        this.top = top;
    }

    public BigDecimal getTop() {
        return top;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUuid() {
        return uuid;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setTempId(Long tempId) {
        this.tempId = tempId;
    }

    public Long getTempId() {
        return tempId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("defaultValue", getDefaultValue())
                .append("dragable2str", getDragable2str())
                .append("height", getHeight())
                .append("isEdit", getIsEdit())
                .append("left", getLeft())
                .append("lodopStyle2str", getLodopStyle2str())
                .append("name", getName())
                .append("resizable2str", getResizable2str())
                .append("style2str", getStyle2str())
                .append("title", getTitle())
                .append("top", getTop())
                .append("type", getType())
                .append("uuid", getUuid())
                .append("value", getValue())
                .append("width", getWidth())
                .append("tempId", getTempId())
                .toString();
    }
}
