package com.tbyf.his.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.enums.ApiInfo;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.common.utils.SecurityUtils;
import com.tbyf.his.framework.datasource.DataSourceUtil;
import com.tbyf.his.framework.system.service.ISysConfigService;
import com.tbyf.his.framework.system.service.ISysDictTypeService;
import com.tbyf.his.system.mapper.SysCommonMapper;
import com.tbyf.his.system.service.ISysCommonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service
public class SysCommonServiceImpl implements ISysCommonService {
    @Autowired
    private ISysConfigService configService;
    @Autowired
    private ISysDictTypeService dictTypeService;
    @Autowired
    private SysCommonMapper sysCommonMapper;
    @Autowired
    private IApiconvertBaseinfoService apiService;

    /**
     * 项目启动时，初始化参数到缓存
     */
    @PostConstruct
    public void init() {
        configService.loadingConfigCache();
        dictTypeService.loadingDictCache();
    }

    @Override
    public String getHisDbName() {
        return configService.selectConfigByKey("his.db.name");
    }

    @Override
    public String getHisParam(String paramCode) {
        JSONObject apiParam = new JSONObject();
        apiParam.put("paramNum", paramCode);
        apiParam.put("orgcode", SecurityUtils.getOrgCode());
        JSONObject pop = apiService.getObjByApi(ApiInfo.HIS_PARAM.getId(), apiParam);
        return pop.getString("val");
    }

    @Override
    public Date getHisDate() {
        JSONObject pop = apiService.getObjByApi(ApiInfo.HIS_DATE.getId(), new JSONObject());
        return pop.getDate("SYSDATE");
    }

    @Override
    public List<JSONObject> selectList(String sqlStr, Map<String, Object> param) {

        return selectList(getHisDbName(), sqlStr, param);
    }

    @Override
    public List<JSONObject> selectList(String dsName, String sqlStr, Map<String, Object> param) {
        DataSourceUtil.switchDs(dsName);
        List<JSONObject> list = sysCommonMapper.selectList(sqlStr, param);
        DataSourceUtil.switchDefaultDs();
        return list;
    }

    @Override
    public JSONObject selectOne(String sqlStr, Map<String, Object> param) {
        return selectOne(getHisDbName(), sqlStr, param);
    }

    @Override
    public JSONObject selectOne(String dsName, String sqlStr, Map<String, Object> param) {
        DataSourceUtil.switchDs(dsName);
        //从his数据库查询系统参数
        JSONObject map = sysCommonMapper.selectOne(sqlStr, param);
        DataSourceUtil.switchDefaultDs();
        return map;
    }

    @Override
    public JSONObject selectOneByPk(String tbName, String pkName, String dataId) {
        return sysCommonMapper.selectOneByPk(tbName, pkName, dataId);
    }

    @Override
    public void insertOne(String sqlStr, Map<String, Object> param) {
        sysCommonMapper.insertOne(sqlStr, param);
    }

    @Override
    public void updateOne(String sqlStr, Map<String, Object> param) {
        sysCommonMapper.updateOne(sqlStr, param);
    }

    @Override
    public void deleteOne(String sqlStr, Map<String, Object> param) {
        sysCommonMapper.deleteOne(sqlStr, param);
    }

    @Override
    public void updatePopData(JSONObject pData) {
        sysCommonMapper.updatePopData(pData);
    }
}
