package com.tbyf.his.web.dataImport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.RuleValidator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.regex.Pattern;

/**
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(DiConstants.SERVICE_PREFIX + DiConstants.VALID_MODE_REG)
@Slf4j
public class RegValidator implements RuleValidator {
    @Override
    public void validate(RuleVO rule) {
        try {
            final boolean matches = Pattern.matches(rule.getContent(), rule.getValue());
            if (!matches) {
                rule.setResult(StringUtils.format("正则表达式{}校验未通过", rule.getContent()));
            }
        } catch (Exception e) {
            log.error("正则表达式校验未通过", e);
            rule.setResult(StringUtils.format("正则表达式{}校验未通过", rule.getContent()));
        }
    }
}
