package com.tbyf.his.web.controller.dataset;

import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.platform.domain.BDataset;
import com.tbyf.his.platform.service.IBDatasetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 数据集 信息操作处理
 *
 * @author guopx
 * @date 2020/10/19
 */
@RestController
@RequestMapping("/platform/dataSet/bDataset")
public class BDatasetController extends BaseController {
    @Autowired
    private IBDatasetService bDatasetService;

    /**
     * 查询数据集列表
     */
    @GetMapping("/list")
    public List<BDataset> list(BDataset bDataset) {
        List<BDataset> list = bDatasetService.selectBDatasetList(bDataset);
        return list;
    }

}
