package com.tbyf.his.web.dataImport.core.convert;

import cn.hutool.core.util.StrUtil;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.ValueConvert;
import org.springframework.stereotype.Service;

@Service
public class RangeConvert implements ValueConvert {
    @Override
    public String convert(RuleVO vo) {
        if (StrUtil.isNotBlank(vo.getValue())){
            String[] dictArr = vo.getContent().split(DiConstants.SEPARATOR);
            for (String dict : dictArr){
                if (StrUtil.isNotBlank(dict) && StrUtil.contains(dict,"-")){
                    String[] split = dict.split("-");
                    if (StrUtil.equalsIgnoreCase(split[0],vo.getValue())){
                        return split[1];
                    }
                }
            }
        }
        return vo.getValue();
    }

    @Override
    public boolean support(RuleVO vo) {
        return StrUtil.equals(vo.getMode(),"值域转换") && StrUtil.equals(vo.getType(),"转换规则");
    }
}
