package com.tbyf.his.web.dataImport.core.convert;

import cn.hutool.core.util.StrUtil;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.ValueConvert;
import org.springframework.stereotype.Service;

@Service
public class RegConvert implements ValueConvert {
    @Override
    public String convert(RuleVO vo) {
        if (StrUtil.isNotBlank(vo.getValue())){
            String[] split = vo.getValue().split(vo.getContent());
            return String.valueOf(split.length);
        }
        return "0";
    }

    @Override
    public boolean support(RuleVO vo) {
        return StrUtil.equals(vo.getMode(),"正则分割") && StrUtil.equals(vo.getType(),"转换规则");
    }
}
