package com.tbyf.his.platform.mapper;

import com.tbyf.his.platform.domain.BDataset;

import java.util.List;


/**
 * 数据集 数据层
 *
 * @author guopx
 * @date 2020/10/19
 */
public interface BDatasetMapper {
    /**
     * 查询数据集信息
     *
     * @param id
     * @return 数据集信息
     */
    public BDataset selectBDatasetById(String id);

    /**
     * 查询数据集列表
     *
     * @param bDataset 数据集信息
     * @return 数据集集合
     */
    public List<BDataset> selectBDatasetList(BDataset bDataset);


    /**
     * 新增数据集
     *
     * @param bDataset 数据集信息
     * @return 结果
     */
    public int insertBDataset(BDataset bDataset);

    /**
     * 修改数据集
     *
     * @param bDataset 数据集信息
     * @return 结果
     */
    public int updateBDataset(BDataset bDataset);

    /**
     * 批量删除数据集
     *
     * @param id 数据集ID
     * @return 结果
     */
    public int deleteBDatasetById(Long id);

    /**
     * 批量删除数据集信息
     *
     * @param ids 需要删除的数据集ID
     * @return 结果
     */
    public int deleteBDatasetByIds(String[] ids);

    /**
     * 判断是否是数据主集
     *
     * @param id 数据集编码
     * @return
     */
    public int isPrimaryBDataset(String id);

    /**
     * 判断数据集是否已发布
     *
     * @param id 数据集编码
     * @return
     */
    public int isPublished(String id);

    /**
     * 判断数据集是否已订阅
     *
     * @param id 数据集编码
     * @return
     */
    public int isSubscribed(String id);


    /**
     * 通过数据集查询出数据集及子数据集编码
     *
     * @param dATASETCODE 数据集编码
     * @return
     */
    String[] selectDataSetCodes(String dATASETCODE);
}
