package com.tbyf.his.platform.service.impl;

import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.platform.domain.PfIdLabel;
import com.tbyf.his.platform.mapper.PMPubliserviewMapper;
import com.tbyf.his.platform.service.IPMPubliserviewService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;


/**
 * 发布数据集Service业务层处理
 *
 * @author guopx
 * @date 2020-10-30
 */
@DataSource(value = DataSourceType.SLAVE)
@Service
public class PMPubliserviewServiceImpl implements IPMPubliserviewService {
    @Resource
    private PMPubliserviewMapper pMPubliserviewMapper;


    @Override
    public List<PfIdLabel> selectPublisherTree() {
        return pMPubliserviewMapper.selectPublisherTree();
    }


    @Override
    public List<PfIdLabel> selectDataSetsByPub(String publisercode) {
        return pMPubliserviewMapper.selectDataSetsByPub(publisercode);
    }
}
