package com.tbyf.his.system.mapper;

import java.util.List;

import com.tbyf.his.framework.web.domain.server.Sys;
import com.tbyf.his.system.domain.SysModule;
import org.springframework.data.repository.query.Param;

/**
 * 应用模块管理Mapper接口
 *
 * @author zq
 * @date 2022-05-30
 */
public interface SysModuleMapper {
    /**
     * 查询应用模块管理
     *
     * @param moduleId 应用模块管理主键
     * @return 应用模块管理
     */
    public SysModule selectSysModuleByModuleId(Long moduleId);

    /**
     * 查询应用模块管理列表
     *
     * @param sysModule 应用模块管理
     * @return 应用模块管理集合
     */
    public List<SysModule> selectSysModuleList(SysModule sysModule);

    /**
     * 新增应用模块管理
     *
     * @param sysModule 应用模块管理
     * @return 结果
     */
    public int insertSysModule(SysModule sysModule);

    /**
     * 修改应用模块管理
     *
     * @param sysModule 应用模块管理
     * @return 结果
     */
    public int updateSysModule(SysModule sysModule);

    /**
     * 删除应用模块管理
     *
     * @param moduleId 应用模块管理主键
     * @return 结果
     */
    public int deleteSysModuleByModuleId(Long moduleId);

    /**
     * 批量删除应用模块管理
     *
     * @param moduleIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSysModuleByModuleIds(Long[] moduleIds);

    /**
     * 查询是否有下级列表
     *
     * @param moduleId 根据Id判断是否拥有下级列表
     * @return
     */
    public int hasChildByModuleId(String moduleId);

    /**
     * 判断查询的的数据是否唯一
     *
     * @param
     * @return
     */
    SysModule checkMenuNameUnique(SysModule sysModule);
}
