package com.tbyf.his.web.controller.system;

import java.util.List;
import java.util.Set;

import com.tbyf.his.common.config.RuoYiConfig;
import com.tbyf.his.common.constant.Constants;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.domain.entity.SysMenu;
import com.tbyf.his.common.core.domain.entity.SysUser;
import com.tbyf.his.common.core.domain.model.LoginUser;
import com.tbyf.his.common.utils.SecurityUtils;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.framework.system.service.ISysMenuService;
import com.tbyf.his.framework.web.service.SysPermissionService;
import com.tbyf.his.login.domain.LoginBody;
import com.tbyf.his.login.service.SysLoginService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 登录验证
 *
 * @author guopx
 */
@Api(tags = "登录验证")
@RestController
public class SysLoginController {

    @Autowired
    private SysLoginService loginService;

    @Autowired
    private ISysMenuService menuService;

    @Autowired
    private SysPermissionService permissionService;

    /**
     * 登录方法
     *
     * @param loginBody 登录信息
     * @return 结果
     */
    @ApiOperation("用户名密码登录")
    @PostMapping("/login")
    public AjaxResult login(@RequestBody LoginBody loginBody) {
        AjaxResult ajax = AjaxResult.success();
        // 生成令牌
        String token = loginService.login(loginBody.getUsername(), loginBody.getPassword(), loginBody.getCode(),
                loginBody.getUuid());
        ajax.put(Constants.TOKEN, token);
        return ajax;
    }

    /**
     * 授权码 登录
     *
     * @param loginBody 登录信息
     * @return 结果
     */
    @ApiOperation("授权码 登录")
    @PostMapping("/loginByAuthCode")
    @ApiResponse(code = 200, message = "登录成功")
    public AjaxResult loginByAuthCode(@RequestBody LoginBody loginBody) {
        AjaxResult ajax = AjaxResult.success();
        // 生成令牌
        String token = loginService.loginByAuthCode(loginBody.getUsername(), loginBody.getAuthCode());
        ajax.put(Constants.TOKEN, token);
        return ajax;
    }

    /**
     * 获取用户信息
     *
     * @return 用户信息
     */
    @ApiOperation("获取用户信息")
    @GetMapping("getInfo")
    public AjaxResult getInfo() {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        SysUser user = loginUser.getUser();

        // 角色集合
        Set<String> roles = permissionService.getRolePermission(user);
        // 权限集合
        Set<String> permissions = permissionService.getMenuPermission(user);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("user", user);
        ajax.put("roles", roles);
        ajax.put("permissions", permissions);
        return ajax;
    }

    /**
     * 获取路由信息
     *
     * @return 路由信息
     */
    @GetMapping("getRouters")
    public AjaxResult getRouters(Long appId) {
        Long userId = SecurityUtils.getUserId();
        List<SysMenu> menus = menuService.selectMenuTreeByUserId(userId, appId);
        return AjaxResult.success(menuService.buildMenus(menus));
    }

}
