package com.tbyf.his.job.obj;

import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.apiconvert.service.IApiconvertBaseinfoService;
import com.tbyf.his.common.exception.ServiceException;
import com.tbyf.his.job.domain.SysJobNew;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author: fr
 * @date: 2022年07月25日 14:53
 */
@Service
public class JobExecuteInterface implements JobExecute, InitializingBean, DisposableBean {

    private static final Logger logger = LoggerFactory.getLogger(JobExecuteInterface.class);

    @Autowired
    private IApiconvertBaseinfoService apiconvertBaseinfoService;

    @Override
    public void execute(SysJobNew job) throws Exception {
        logger.info("[定时任务]执行接口:{}", job);
        String[] apiIds = job.getApiIds().split(",");
        // 首个接口空参传递，后续的接口参数用前面接口返回结果
        JSONObject param = new JSONObject();
        for (String apiId : apiIds) {
            try {
                param = apiconvertBaseinfoService.getObjByApi(Long.parseLong(apiId), param);
            } catch (Exception e) {
                e.printStackTrace();
                logger.info("执行接口出错，参数{} - {}，错误信息：{}", apiId, param, e.getMessage());
                throw new ServiceException("执行接口[" + apiId + "]出错");
            }
        }
        logger.info("[定时任务]执行接口结果:{}", param);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        // 注册进入工厂
        JobExecuteFactory.register(JobEnum.EXECUTE_INTERFACE, this);
    }

    @Override
    public void destroy() throws Exception {
        JobExecuteFactory.remove(JobEnum.EXECUTE_INTERFACE, this);
    }
}
