package com.tbyf.his.print.domain;


import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;
import java.util.List;

/**
 * 打印模板对象 print_template
 *
 * @author x
 * @date 2022-02-25
 */
public class PrintTemplate extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    private Long id;

    /**
     * 名称
     */
    @Excel(name = "名称")
    private String name;

    /**
     * 备注
     */
    @Excel(name = "备注")
    private String description;

    /**
     * 宽度
     */
    @Excel(name = "宽度")
    private BigDecimal width;

    /**
     * 高度
     */
    @Excel(name = "高度")
    private BigDecimal height;

    /**
     * 纸张宽度
     */
    @Excel(name = "纸张宽度")
    private BigDecimal pageWidth;

    /**
     * 纸张高度
     */
    @Excel(name = "纸张高度")
    private BigDecimal pageHeight;

    private Long datasetId;

    private List<PrintTempItem> tempItems;

    public List<PrintTempItem> getTempItems() {
        return tempItems;
    }

    public void setTempItems(List<PrintTempItem> tempItems) {
        this.tempItems = tempItems;
    }

    public Long getDatasetId() {
        return datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public void setWidth(BigDecimal width) {
        this.width = width;
    }

    public BigDecimal getWidth() {
        return width;
    }

    public void setHeight(BigDecimal height) {
        this.height = height;
    }

    public BigDecimal getHeight() {
        return height;
    }

    public void setPageWidth(BigDecimal pageWidth) {
        this.pageWidth = pageWidth;
    }

    public BigDecimal getPageWidth() {
        return pageWidth;
    }

    public void setPageHeight(BigDecimal pageHeight) {
        this.pageHeight = pageHeight;
    }

    public BigDecimal getPageHeight() {
        return pageHeight;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("name", getName())
                .append("description", getDescription())
                .append("width", getWidth())
                .append("height", getHeight())
                .append("pageWidth", getPageWidth())
                .append("pageHeight", getPageHeight())
                .append("datasetId", getDatasetId())
                .toString();
    }
}
