package com.tbyf.his.web.controller.dataImport;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tbyf.his.common.annotation.IgnoreWebSecurity;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.bean.BeanUtils;
import com.tbyf.his.web.dataImport.core.DiConfig;
import com.tbyf.his.web.dataImport.domain.param.AddFieldParam;
import com.tbyf.his.web.dataImport.domain.param.QueryFieldParam;
import com.tbyf.his.web.dataImport.domain.param.QueryMetaFieldParam;
import com.tbyf.his.web.dataImport.domain.param.UpdateFieldParam;
import com.tbyf.his.web.dataImport.entity.*;
import com.tbyf.his.web.dataImport.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/2/16 15:29
 */
@RestController
@Api(tags = "数据字段接口")
@RequestMapping("/data/field")
@Slf4j
public class DataFieldController {

    @Autowired
    private DataFieldService dataFieldService;

    @Autowired
    private BindRuleService bindRuleService;

    @Autowired
    private DataTemplateService dataTemplateService;

    @Autowired
    private ExcelDataService excelDataService;

    @Autowired
    private MetaFieldService metaFieldService;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @IgnoreWebSecurity
    @GetMapping("")
    @ApiOperation("字段查询")
    public TableDataInfo queryField(@Validated QueryFieldParam param) {
        /*final Page<DataField> page = Page.of(param.getPageNum(), param.getPageSize());
        final LambdaQueryWrapper<DataField> queryWrapper = Wrappers.lambdaQuery(DataField.class);
        queryWrapper.eq(StringUtils.isNotBlank(param.getTemplateId()), DataField::getTemplateId, param.getTemplateId())
                .like(StringUtils.isNotBlank(param.getCode()), DataField::getCode, param.getCode())
                .like(StringUtils.isNotBlank(param.getTitle()), DataField::getTitle, param.getTitle())
                .like(StringUtils.isNotBlank(param.getCoordinate()), DataField::getCoordinate, param.getCoordinate())
                .like(StringUtils.isNotBlank(param.getField()), DataField::getField, param.getField());
        final Page<DataField> templatePage = dataFieldService.page(page, queryWrapper);*/
        return param.convert(dataFieldService.queryField(param));
    }

    @IgnoreWebSecurity
    @PostMapping("")
    @ApiOperation("字段新增")
    public AjaxResult addField(@RequestBody @Validated AddFieldParam param) {
        DataField field = new DataField();
        BeanUtils.copyProperties(param, field);
        dataFieldService.save(field);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @PostMapping("/update")
    @ApiOperation("修改字段")
    public AjaxResult updateField(@RequestBody @Validated UpdateFieldParam param) {
        DataField field = new DataField();
        BeanUtils.copyProperties(param, field);
        dataFieldService.updateById(field);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/delete")
    @ApiOperation("删除字段")
    public AjaxResult deleteField(@RequestParam String fieldId) {
        dataFieldService.removeById(fieldId);
        bindRuleService.remove(Wrappers.lambdaQuery(BindRule.class).eq(BindRule::getDataId, fieldId));
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/reset")
    @ApiOperation("根据基础模板重置字段")
    public AjaxResult resetField(@RequestParam String excelId, @RequestParam(required = false) String year) {
        final ExcelData excelData = excelDataService.getById(excelId);
        // 获取元字段列表
        final List<MetaField> metaFields = metaFieldService.list();
        // 获取需要同步的字段列表
        List<DataField> fieldMatchList = null;
        if (StringUtils.isNotBlank(year)) {
            DataTemplate template = dataTemplateService.getOne(Wrappers.lambdaQuery(DataTemplate.class)
                    .eq(DataTemplate::getYear, year).eq(DataTemplate::getOrgName, excelData.getOrgName()), false);
            fieldMatchList = dataFieldService.list(Wrappers.lambdaQuery(DataField.class)
                    .eq(DataField::getTemplateId, template.getId()).isNotNull(DataField::getField));
        }
        // 删除掉之前的模板信息
        final LambdaQueryWrapper<DataField> wrapper = Wrappers.lambdaQuery(DataField.class).eq(DataField::getTemplateId, excelData.getTemplateId());
        final List<DataField> list = dataFieldService.list(wrapper);
        if (!CollectionUtils.isEmpty(list)) {
            final List<String> fieldIdList = list.stream().map(DataField::getId).collect(Collectors.toList());
            bindRuleService.remove(Wrappers.lambdaQuery(BindRule.class).in(BindRule::getDataId, fieldIdList));
        }
        dataFieldService.remove(Wrappers.lambdaQuery(DataField.class).eq(DataField::getTemplateId, excelData.getTemplateId()));
        try (InputStream is = new ByteArrayInputStream(excelData.getFile()); Workbook workbook = WorkbookFactory.create(is)) {
            final Sheet sheet = workbook.getSheetAt(0);
            final int rows = sheet.getLastRowNum() + 1;
            List<DataField> fieldList = new ArrayList<>();
            for (int i = 1; i < rows; i++) {
                final Row row = sheet.getRow(i);
                String code = DiConfig.getValue(row.getCell(1, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL));
                String title = DiConfig.getValue(row.getCell(2, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL));
                String unit = DiConfig.getValue(row.getCell(4, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL));
                if (StringUtils.isAllBlank(code, title, unit)) {
                    continue;
                }
                if (StringUtils.equals(code, "代码") || StringUtils.equals(title, "指标名称") || StringUtils.equals(unit, "计量单位")) {
                    continue;
                }
                final DataField dataField = new DataField();
                dataField.setTemplateId(excelData.getTemplateId());
                dataField.setCode(code);
                dataField.setTitle(title);
                dataField.setUnit(unit);
                // TODO 这里坐标修改为i+1是因为excel文件中展示的第一行号是1,符合直觉
                dataField.setCoordinate("F," + (i + 1));
                dataField.setSort(i + 1);
                // 字段绑定需要进行模糊匹配
                dataFieldService.fieldMatch(metaFields, dataField, fieldMatchList);
                fieldList.add(dataField);
            }
            dataFieldService.saveBatch(fieldList);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/meta")
    @ApiOperation("元字段查询")
    public TableDataInfo queryField(@Validated QueryMetaFieldParam param) {
        final Page<MetaField> page = Page.of(param.getPageNum(), param.getPageSize());
        final LambdaQueryWrapper<MetaField> queryWrapper = Wrappers.lambdaQuery(MetaField.class);
        queryWrapper.like(StringUtils.isNotBlank(param.getFieldName()), MetaField::getFieldName, param.getFieldName())
                .like(StringUtils.isNotBlank(param.getFieldType()), MetaField::getFieldType, param.getFieldType())
                .like(StringUtils.isNotBlank(param.getFieldComment()), MetaField::getFieldComment, param.getFieldComment());
        final Page<MetaField> templatePage = metaFieldService.page(page, queryWrapper);
        return param.convert(templatePage);
    }

    @IgnoreWebSecurity
    @PostMapping("/meta")
    @ApiOperation("元字段新增")
    public AjaxResult addMetaField(@RequestBody @Validated MetaField field) {
        metaFieldService.save(field);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @PostMapping("/meta/update")
    @ApiOperation("修改元字段")
    public AjaxResult updateMeatField(@RequestBody @Validated MetaField field) {
        metaFieldService.updateById(field);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/meta/delete")
    @ApiOperation("删除元字段")
    public AjaxResult deleteMetaField(@RequestParam String fieldId) {
        metaFieldService.removeById(fieldId);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/meta/dict")
    @ApiOperation("查询元字段字典")
    public AjaxResult getMetaFieldDict() {
        return AjaxResult.success(metaFieldService.list());
    }


    @IgnoreWebSecurity
    //@GetMapping("/testQuick")
    //@ApiOperation("查询原来模板的字段")
    public AjaxResult testQuick() {
        try {
            DataSourceService.switchDb("datacenter");
            final List<String> list = Arrays.asList("T0801_SERVERCENTER", "T0801_HEALTHCENTER",
                    "T0801_SERSTATION", "T0801_CLINIC", "T0801_TCMHOSP");
            String sql = "SELECT UCO.TABLE_NAME ,UCO.COMMENTS, UCO.COLUMN_NAME,UTO.DATA_TYPE,UTO.DATA_LENGTH,UTO.DATA_PRECISION,UTO.DATA_SCALE FROM\n" +
                    "USER_COL_COMMENTS UCO LEFT JOIN USER_TAB_COLUMNS UTO ON UCO.COLUMN_NAME = UTO.COLUMN_NAME\n" +
                    "WHERE UCO.TABLE_NAME = UPPER('{}') AND UTO.TABLE_NAME = UPPER('{}')";
            List<MetaField> metaFieldList = new ArrayList<>();
            list.forEach(item -> {
                final List<Map<String, Object>> mapList = jdbcTemplate.queryForList(StrFormatter.format(sql, item, item));
                mapList.forEach(v -> {
                    final MetaField metaField = new MetaField();
                    metaField.setRemarks(String.valueOf(v.get("TABLE_NAME")));
                    metaField.setFieldName(String.valueOf(v.get("COLUMN_NAME")));
                    String fieldType = String.valueOf(v.get("DATA_TYPE"));
                    if (Objects.isNull(v.get("DATA_PRECISION"))) {
                        metaField.setFieldType(fieldType + "(" + v.get("DATA_LENGTH") + ")");
                    } else {
                        fieldType = fieldType + "(" +
                                v.get("DATA_PRECISION") +
                                (Objects.isNull(v.get("DATA_SCALE")) ? ")" : "," + v.get("DATA_SCALE") + ")");
                        metaField.setFieldType(fieldType);
                    }
                    metaField.setFieldComment(StringUtils.trim((String) v.get("COMMENTS")));
                    metaFieldList.add(metaField);
                });
            });
            List<MetaField> fieldList = metaFieldList.stream()
                    .filter(DataImportController.distinctByKey(MetaField::getFieldName))
                    .distinct().collect(Collectors.toList());
            DataSourceService.switchDefault();
            metaFieldService.saveBatch(fieldList);
        } finally {
            DataSourceService.switchDefault();
        }
        return AjaxResult.success();
    }

}
