package com.tbyf.his.web.dataImport.core.validator;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.core.DiConstants;
import com.tbyf.his.web.dataImport.core.RuleVO;
import com.tbyf.his.web.dataImport.core.RuleValidator;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 比较规则校验
 * 目前支持符号为 > >= < <= = !=
 *
 * @author lzz
 * @date 2023/1/29 14:21
 */
@Service(DiConstants.SERVICE_PREFIX + DiConstants.VALID_MODE_COMPARE)
@Slf4j
public class CompareValidator implements RuleValidator {

    public static final String GT = ">";

    public static final String GTE = ">=";

    public static final String LT = "<";

    public static final String LTE = "<=";

    public static final String EQ = "=";

    public static final String NEQ = "!=";

    private String getValue(String value, String symbol) {
        return value.trim().substring(symbol.length()).trim();
    }

    @Override
    public void validate(RuleVO rule) {
        try {
            if (rule.getContent().startsWith(GT)) {
                final BigDecimal x = new BigDecimal(getValue(rule.getContent(), GT));
                if (new BigDecimal(rule.getValue()).compareTo(x) <= 0) {
                    rule.setResult(StringUtils.format("比较 {} 未通过", rule.getContent()));
                }
            } else if (rule.getContent().startsWith(GTE)) {
                final BigDecimal x = new BigDecimal(getValue(rule.getContent(), GTE));
                if (new BigDecimal(rule.getValue()).compareTo(x) < 0) {
                    rule.setResult(StringUtils.format("比较 {} 未通过", rule.getContent()));
                }
            } else if (rule.getContent().startsWith(LT)) {
                final BigDecimal x = new BigDecimal(getValue(rule.getContent(), LT));
                if (new BigDecimal(rule.getValue()).compareTo(x) >= 0) {
                    rule.setResult(StringUtils.format("比较 {} 未通过", rule.getContent()));
                }
            } else if (rule.getContent().startsWith(LTE)) {
                final BigDecimal x = new BigDecimal(getValue(rule.getContent(), LTE));
                if (new BigDecimal(rule.getValue()).compareTo(x) > 0) {
                    rule.setResult(StringUtils.format("比较 {} 未通过", rule.getContent()));
                }
            } else if (rule.getContent().startsWith(EQ)) {
                final String content = getValue(rule.getContent(), EQ);
                if (!StringUtils.equals(rule.getValue().trim(), content)) {
                    rule.setResult(StringUtils.format("比较 {} 未通过", rule.getContent()));
                }
            } else if (rule.getContent().startsWith(NEQ)) {
                final String content = getValue(rule.getContent(), NEQ);
                if (StringUtils.equals(rule.getValue().trim(), content)) {
                    rule.setResult(StringUtils.format("比较 {} 未通过", rule.getContent()));
                }
            }
        } catch (Exception e) {
            log.error("比较未通过", e);
            rule.setResult(StringUtils.format("比较 {} 未通过", rule.getContent()));
        }
    }
}
