package com.tbyf.his.adapter.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import lombok.Data;


/**
 * 业务代码值域表 P_B_CODEVALUE
 *
 * @author guopx
 * @date 2020/10/15
 */

public class BCodevalue extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 基础代码表编码
     */
    @Excel(name = "基础代码表编码")
    private String bASECODETABLECODE;
    /**
     * 代码编码
     */
    @Excel(name = "代码编码")
    private String vALUECODE;
    /**
     * 代码名称
     */
    @Excel(name = "代码名称")
    private String vALUENAME;
    /**
     * 备注
     */
    @Excel(name = "备注")
    private String mEMO;
    /**
     * 拼音码
     */
    @Excel(name = "拼音码")
    private String pYM;
    /**
     * 上级代码
     */
    @Excel(name = "上级代码")
    private String pARENTCODE;
    /**
     * 特殊类别标识 CF77.00.001对应最后索引时间
     */
    private String sPECIALTYPE;
    /**
     * Format格式   CF77.00.001文档类别对应报表名称
     */
    private String vALUEFORAT;
    /**
     * CF77.00.001 http URL采用的编码
     */
    private String fieldExtend;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getbASECODETABLECODE() {
        return bASECODETABLECODE;
    }

    public void setbASECODETABLECODE(String bASECODETABLECODE) {
        this.bASECODETABLECODE = bASECODETABLECODE;
    }

    public String getvALUECODE() {
        return vALUECODE;
    }

    public void setvALUECODE(String vALUECODE) {
        this.vALUECODE = vALUECODE;
    }

    public String getvALUENAME() {
        return vALUENAME;
    }

    public void setvALUENAME(String vALUENAME) {
        this.vALUENAME = vALUENAME;
    }

    public String getmEMO() {
        return mEMO;
    }

    public void setmEMO(String mEMO) {
        this.mEMO = mEMO;
    }

    public String getpYM() {
        return pYM;
    }

    public void setpYM(String pYM) {
        this.pYM = pYM;
    }

    public String getpARENTCODE() {
        return pARENTCODE;
    }

    public void setpARENTCODE(String pARENTCODE) {
        this.pARENTCODE = pARENTCODE;
    }

    public String getsPECIALTYPE() {
        return sPECIALTYPE;
    }

    public void setsPECIALTYPE(String sPECIALTYPE) {
        this.sPECIALTYPE = sPECIALTYPE;
    }

    public String getvALUEFORAT() {
        return vALUEFORAT;
    }

    public void setvALUEFORAT(String vALUEFORAT) {
        this.vALUEFORAT = vALUEFORAT;
    }

    public String getFieldExtend() {
        return fieldExtend;
    }

    public void setFieldExtend(String fieldExtend) {
        this.fieldExtend = fieldExtend;
    }

    @Override
    public String toString() {
        return "BCodevalue{" +
                "bASECODETABLECODE='" + bASECODETABLECODE + '\'' +
                ", vALUECODE='" + vALUECODE + '\'' +
                ", vALUENAME='" + vALUENAME + '\'' +
                ", mEMO='" + mEMO + '\'' +
                ", pYM='" + pYM + '\'' +
                ", pARENTCODE='" + pARENTCODE + '\'' +
                ", sPECIALTYPE='" + sPECIALTYPE + '\'' +
                ", vALUEFORAT='" + vALUEFORAT + '\'' +
                ", fieldExtend='" + fieldExtend + '\'' +
                '}';
    }
}
