package com.tbyf.his.adapter.mapper;

import com.tbyf.his.adapter.domain.AdapterPublishTable;
import com.tbyf.his.adapter.domain.AdapterPublishTask;
import com.tbyf.his.adapter.domain.PublishColumnDto;
import com.tbyf.his.adapter.domain.ValueDomainDto;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * @description 针对表【ADAPTER_PUBLISH_TASK】的数据库操作Mapper
 */
public interface AdapterPublishTaskMapper {

    /**
     * 根据数据源名称查找存在发布列的发布表
     */
    List<AdapterPublishTable> getList(@Param("sourceName") String sourceName, @Param("publishTableName") String publishTableName);

    /**
     * 更新发布任务
     */
    void updateAdapterPublishTask(AdapterPublishTask adapterPublishTask);

    @DataSource(DataSourceType.SLAVE)
    int updateTaskInfo(AdapterPublishTask adapterPublishTask);

    /**
     * 查找发布任务
     */
    AdapterPublishTask selectTaskByPublishTableNameAndSourceName(@Param("publishTableName") String publishTableName, @Param("sourceName") String sourceName);

    /**
     * 新增发布任务
     */
    void insertAdapterPublishTask(AdapterPublishTask adapterPublishTask);

    /**
     * 修改任务状态
     */
    void updateAdapterPublishTaskStatus(@Param("status") String status, @Param("id") Long id);

    /**
     * 删除发布任务
     */
    int deleteAdapterPublishTaskById(Long id);

    /**
     * 查询指定状态的任务
     */
    List<AdapterPublishTask> selectTaskByStatus(String status);

    List<PublishColumnDto> selectColumnByTableSource(@Param("tableName") String tableName, @Param("dataSourceId") String dataSourceId);

    /**
     * 获取值域数据
     *
     * @param domainCode
     * @return
     */
    ValueDomainDto selectValueDomainList(@Param("domainCode") String domainCode, @Param("value") String value);

    List<Map<String, String>> execute(String sql);

    /**
     * 获取指定数据源ID的驱动类
     *
     * @param dataSourceId
     * @return
     */
    @DataSource(dsName = "master")
    String getDataSourceDriver(String dataSourceId);

}
