package com.tbyf.his.print.service;


import com.tbyf.his.print.domain.PrintTempItem;

import java.util.List;

/**
 * 打印模板项Service接口
 *
 * @author x
 * @date 2022-02-28
 */
public interface IPrintTempItemService {
    /**
     * 查询打印模板项
     *
     * @param id 打印模板项主键
     * @return 打印模板项
     */
    public PrintTempItem selectPrintTempItemById(Long id);

    /**
     * 查询打印模板项列表
     *
     * @param printTempItem 打印模板项
     * @return 打印模板项集合
     */
    public List<PrintTempItem> selectPrintTempItemList(PrintTempItem printTempItem);

    /**
     * 新增打印模板项
     *
     * @param printTempItem 打印模板项
     * @return 结果
     */
    public int insertPrintTempItem(PrintTempItem printTempItem);

    /**
     * 修改打印模板项
     *
     * @param printTempItem 打印模板项
     * @return 结果
     */
    public int updatePrintTempItem(PrintTempItem printTempItem);

    /**
     * 批量删除打印模板项
     *
     * @param ids 需要删除的打印模板项主键集合
     * @return 结果
     */
    public int deletePrintTempItemByIds(Long[] ids);

    /**
     * 删除打印模板项信息
     *
     * @param id 打印模板项主键
     * @return 结果
     */
    public int deletePrintTempItemById(Long id);
}
