package com.tbyf.his.web.controller.configuration;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.configuration.domain.ImportParam;
import com.tbyf.his.configuration.domain.WsConfigDetail;
import com.tbyf.his.configuration.service.IWsConfigDetailService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.enums.BusinessType;

import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.common.core.page.TableDataInfo;

/**
 * detailController
 *
 * @author guopx
 * @date 2022-04-15
 */
@RestController
@RequestMapping("/ws/configDetail")
public class WsConfigDetailController extends BaseController {
    @Autowired
    private IWsConfigDetailService wsConfigDetailService;

    /**
     * 查询detail列表
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:list')")
    @GetMapping("/list")
    public TableDataInfo list(WsConfigDetail wsConfigDetail) {
        startPage();
        List<WsConfigDetail> list = wsConfigDetailService.selectWsConfigDetailList(wsConfigDetail);
        return getDataTable(list);
    }

    /**
     * 导出detail列表
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:export')")
    @Log(title = "detail", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, WsConfigDetail wsConfigDetail) {
        List<WsConfigDetail> list = wsConfigDetailService.selectWsConfigDetailList(wsConfigDetail);
        ExcelUtil<WsConfigDetail> util = new ExcelUtil<WsConfigDetail>(WsConfigDetail.class);
        util.exportExcel(response, list, "detail数据");
    }

    /**
     * 获取detail详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:detail:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(wsConfigDetailService.selectWsConfigDetailById(id));
    }

    /**
     * 新增detail
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:add')")
    @Log(title = "detail", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody WsConfigDetail wsConfigDetail) {
        return toAjax(wsConfigDetailService.insertWsConfigDetail(wsConfigDetail));
    }

    /**
     * 修改detail
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:edit')")
    @Log(title = "detail", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody WsConfigDetail wsConfigDetail) {
        return toAjax(wsConfigDetailService.updateWsConfigDetail(wsConfigDetail));
    }

    /**
     * 删除detail
     */
//    @PreAuthorize("@ss.hasPermi('system:detail:remove')")
    @Log(title = "detail", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(wsConfigDetailService.deleteWsConfigDetailByIds(ids));
    }


    /**
     * 批量保存Detail
     */
    @Log(title = "批量保存Detail", businessType = BusinessType.OTHER)
    @PostMapping("/addDetailList/{wsConfigId}/{xmlFlag}")
    public AjaxResult addDetailList(
            @PathVariable("wsConfigId") Long wsConfigId,
            @PathVariable("xmlFlag") String xmlFlag,
            @RequestBody List<WsConfigDetail> detailList) {
        if (StringUtils.isEmpty(detailList)) {
            return AjaxResult.error("所选数据为空");
        }
        if (StringUtils.isEmpty(xmlFlag)) {
            return AjaxResult.error("请选择所属xml");
        }
        wsConfigDetailService.addDetailList(wsConfigId, xmlFlag, detailList);
        return AjaxResult.success();
    }

    /**
     * 批量修改Detail
     */
    @Log(title = "批量修改Detail", businessType = BusinessType.OTHER)
    @PostMapping("/updateDetailList")
    public AjaxResult updateDetailList(@RequestBody List<WsConfigDetail> detailList) {
        wsConfigDetailService.updateDetailList(detailList);
        return AjaxResult.success();
    }

    /**
     * 生成目标字段
     */
    @Log(title = "生成目标字段", businessType = BusinessType.OTHER)
    @PostMapping("/importTargetKey")
    public AjaxResult importTargetKey(@RequestBody ImportParam importParam) {
        List<Map<String, Object>> r = wsConfigDetailService.importTargetKey(importParam);
        return AjaxResult.success(r);
    }
}
