package com.tbyf.his.system.mapper;

import com.alibaba.fastjson.JSONObject;
import com.tbyf.his.common.core.domain.model.MyKeyValue;
import com.tbyf.his.system.domain.SysDatasource;
import org.apache.ibatis.annotations.*;

import java.util.List;
import java.util.Map;

/**
 * 数据源配置Mapper接口
 *
 * @author guopx
 * @date 2022-03-01
 */
public interface SysCommonMapper {
    //@Select("${sqlStr}")
    List<JSONObject> selectList(@Param(value = "sqlStr") String sqlStr,
                                @Param(value = "param") Map<String, Object> param);

    //@Select("${sqlStr}")
    JSONObject selectOne(@Param(value = "sqlStr") String sqlStr,
                         @Param(value = "param") Map<String, Object> param);

    //@Insert("${sqlStr}")
    void insertOne(@Param(value = "sqlStr") String sqlStr,
                   @Param("param") Map<String, Object> param);

    //@Update("${sqlStr}")
    void updateOne(@Param(value = "sqlStr") String sqlStr,
                   @Param("param") Map<String, Object> param);

    //@Delete("${sqlStr}")
    void deleteOne(@Param(value = "sqlStr") String sqlStr,
                   @Param("param") Map<String, Object> param);

    //@Select("select * from ${tbName} where ${pkName} = #{dataId}")
    JSONObject selectOneByPk(@Param("tbName") String tbName,
                             @Param("pkName") String pkName,
                             @Param("dataId") String dataId);

    //@Select("SELECT CSZ FROM CO_CLIENTCONF WHERE YPBH = #{paramCode} AND JGDM = #{orgCode}")
    String getHisParam(@Param(value = "paramCode") String paramCode,
                       @Param(value = "orgCode") String orgCode);

    void updatePopData(Map<String, Object> param);

}
