package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@TableName(value = "data_field", autoResultMap = true)
@ApiModel(value = "数据字段表", description = "数据字段表")
public class DataField implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "字段ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    @ApiModelProperty(value = "模板ID")
    @TableField("template_id")
    private String templateId;

    @ApiModelProperty(value = "代码")
    @TableField("code")
    private String code;

    @ApiModelProperty(value = "指标名称")
    @TableField("title")
    private String title;

    @ApiModelProperty(value = "计量单位")
    @TableField("unit")
    private String unit;

    @ApiModelProperty(value = "数据起始坐标,例如 C,4")
    @TableField("coordinate")
    private String coordinate;

    @ApiModelProperty(value = "排序字段")
    @TableField("sort")
    private Integer sort;

    @ApiModelProperty(value = "数据库字段名")
    @TableField("field")
    private String field;

}
