package com.tbyf.his.web.controller.system;

import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.system.domain.SysBjgTable;
import com.tbyf.his.system.service.ISysBjgTableService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 结构_说明Controller
 *
 * @author guopx
 * @date 2022-05-12
 */
@RestController
@RequestMapping("/system/table")
public class SysBjgTableController extends BaseController {
    @Autowired
    private ISysBjgTableService sysBjgTableService;

    /**
     * 查询结构_说明列表
     */
    @PreAuthorize("@ss.hasPermi('system:table:list')")
    @GetMapping("/list")
    public TableDataInfo list(SysBjgTable sysBjgTable) {
        startPage();
        List<SysBjgTable> list = sysBjgTableService.selectSysBjgTableList(sysBjgTable);
        return getDataTable(list);
    }

    /**
     * 导出结构_说明列表
     */
    @PreAuthorize("@ss.hasPermi('system:table:export')")
    @Log(title = "结构_说明", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysBjgTable sysBjgTable) {
        List<SysBjgTable> list = sysBjgTableService.selectSysBjgTableList(sysBjgTable);
        ExcelUtil<SysBjgTable> util = new ExcelUtil<SysBjgTable>(SysBjgTable.class);
        util.exportExcel(response, list, "结构_说明数据");
    }

    /**
     * 获取结构_说明详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:table:query')")
    @GetMapping(value = "/{tabName}")
    public AjaxResult getInfo(@PathVariable("tabName") String tabName) {
        return AjaxResult.success(sysBjgTableService.selectSysBjgTableByTabName(tabName));
    }

    /**
     * 模糊查询
     */
    @GetMapping(value = "/likeSelect")
    public TableDataInfo list2(SysBjgTable sysBjgTable) {
        startPage();
        List<SysBjgTable> list = sysBjgTableService.likeSelectSysBjgTable(sysBjgTable);
        return getDataTable(list);
    }

    /**
     * 新增结构_说明
     */
    @PreAuthorize("@ss.hasPermi('system:table:add')")
    @Log(title = "结构_说明", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SysBjgTable sysBjgTable) {
        return toAjax(sysBjgTableService.insertSysBjgTable(sysBjgTable));
    }

    /**
     * 修改结构_说明
     */
    @PreAuthorize("@ss.hasPermi('system:table:edit')")
    @Log(title = "结构_说明", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysBjgTable sysBjgTable) {
        return toAjax(sysBjgTableService.updateSysBjgTable(sysBjgTable));
    }

    /**
     * 删除结构_说明
     */
    @PreAuthorize("@ss.hasPermi('system:table:remove')")
    @Log(title = "结构_说明", businessType = BusinessType.DELETE)
    @DeleteMapping("/{tabNames}")
    public AjaxResult remove(@PathVariable String[] tabNames) {
        return toAjax(sysBjgTableService.deleteSysBjgTableByTabNames(tabNames));
    }
}
