package com.tbyf.his.configuration.domain;

import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * webService服务配置对象 ws_config
 *
 * @author guopx
 * @date 2022-04-14
 */
public class WsConfig extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    private Long id;

    /**
     * $column.columnComment
     */
    @Excel(name = "${comment}", readConverterExp = "$column.readConverterExp()")
    private String wsName;

    /**
     * 业务类编号
     */
    @Excel(name = "业务类编号")
    private String businessNo;


    /**
     * 操作类型
     */
    @Excel(name = "操作类型")
    private String operationType;

    /**
     * 模块ID
     */
    @Excel(name = "应用模块编号")
    private Long moduleId;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setWsName(String wsName) {
        this.wsName = wsName;
    }

    public String getWsName() {
        return wsName;
    }

    public void setBusinessNo(String businessNo) {
        this.businessNo = businessNo;
    }

    public String getBusinessNo() {
        return businessNo;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getOperationType() {
        return operationType;
    }

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("id", getId())
                .append("wsName", getWsName())
                .append("bussinessNo", getBusinessNo())
                .append("operationType", getOperationType())
                .append("remark", getRemark())
                .append("createBy", getCreateBy())
                .append("createTime", getCreateTime())
                .append("updateBy", getUpdateBy())
                .append("updateTime", getUpdateTime())
                .append("moduleId", getModuleId())
                .toString();
    }
}
