package com.tbyf.his.web.controller.print;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.print.domain.PrintDataset;
import com.tbyf.his.print.domain.PrintMetadata;
import com.tbyf.his.print.service.IPrintDatasetService;
import com.tbyf.his.print.service.IPrintMetadataService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 数据集信息Controller
 *
 * @author x
 * @date 2022-02-25
 */
@Api(tags = "打印模板-数据集")
@RestController
@RequestMapping("/print/dataset")
public class PrintDatasetController extends BaseController {
    @Autowired
    private IPrintDatasetService printDatasetService;
    @Autowired
    private IPrintMetadataService printMetadataService;

    /**
     * 查询数据集信息列表
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:list')")
    @GetMapping("/list")
    public TableDataInfo list(PrintDataset printDataset) {
        startPage();
        List<PrintDataset> list = printDatasetService.selectPrintDatasetList(printDataset);
        return getDataTable(list);
    }

    /**
     * 导出数据集信息列表
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:export')")
    @Log(title = "数据集信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, PrintDataset printDataset) {
        List<PrintDataset> list = printDatasetService.selectPrintDatasetList(printDataset);
        ExcelUtil<PrintDataset> util = new ExcelUtil<PrintDataset>(PrintDataset.class);
        util.exportExcel(response, list, "数据集信息数据");
    }

    /**
     * 获取数据集信息详细信息
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:query')")
    @GetMapping(value = "/{datasetId}")
    public AjaxResult getInfo(@PathVariable("datasetId") Long datasetId) {
        return AjaxResult.success(printDatasetService.selectPrintDatasetByDatasetId(datasetId));
    }

    /**
     * 新增数据集信息
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:add')")
    @Log(title = "数据集信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PrintDataset printDataset) {
        return toAjax(printDatasetService.insertPrintDataset(printDataset));
    }

    /**
     * 修改数据集信息
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:edit')")
    @Log(title = "数据集信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PrintDataset printDataset) {
        return toAjax(printDatasetService.updatePrintDataset(printDataset));
    }

    /**
     * 删除数据集信息
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:remove')")
    @Log(title = "数据集信息", businessType = BusinessType.DELETE)
    @DeleteMapping("/{datasetIds}")
    public AjaxResult remove(@PathVariable Long[] datasetIds) {
        return toAjax(printDatasetService.deletePrintDatasetByDatasetIds(datasetIds));
    }


    /**
     * 打印模板设计页左边的数据集fieldList
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:allFieldList')")
    @Log(title = "数据集信息", businessType = BusinessType.OTHER)
    @GetMapping("/allFieldList")
    public AjaxResult allFieldList() {
        List<PrintDataset> list = printDatasetService.allFieldList();
        return AjaxResult.success(list);
    }

    /**
     * 保存fieldList
     */
//    @PreAuthorize("@ss.hasPermi('dataset:dataset:saveFieldList')")
    @Log(title = "数据集信息", businessType = BusinessType.OTHER)
    @PostMapping("/saveFieldList")
    public AjaxResult saveFieldList(@RequestBody List<JSONObject> jsonList) {
        jsonList.forEach(json -> {
            PrintDataset dataset = new PrintDataset();
            dataset.setDatasetName(json.getString("fieldName"));
            int i = printDatasetService.insertPrintDataset(dataset);
            Long datasetId = dataset.getDatasetId();
            JSONArray children = json.getJSONArray("children");
            List<JSONObject> printMetadata = children.toJavaList(JSONObject.class);
            for (JSONObject one : printMetadata) {
                PrintMetadata metadata = JSONObject.toJavaObject(one, PrintMetadata.class);
                metadata.setDatasetId(datasetId);
                metadata.setMetadataName(metadata.getFieldName());
                metadata.setMetadataDescription("1");
                metadata.setDataType("1");
                metadata.setReferenceId(1L);
                metadata.setIsArray("N");
                metadata.setWholeMessageId(1L);
                System.out.println(metadata.toString());
//                PrintMetadata metadata = new PrintMetadata();
//                metadata.setDatasetId(datasetId);
                printMetadataService.insertPrintMetadata(metadata);
            }

        });
        return AjaxResult.success();
    }
}
