package com.tbyf.his.system.service;

import com.tbyf.his.common.core.domain.TreeSelect;
import com.tbyf.his.system.domain.SysCategory;

import java.util.List;

/**
 * 插件种类管理 服务层
 */
public interface ISysCategoryService {

    /**
     * 查询插件种类管理数据
     *
     * @param category 插件种类信息
     * @return 插件种类信息集合
     */
    public List<SysCategory> selectDeptList(SysCategory category);

    /**
     * 构建前端所需要树结构
     *
     * @param categories 插件种类列表
     * @return 树结构列表
     */
    public List<SysCategory> buildCategoryTree(List<SysCategory> categories);

    /**
     * 构建前端所需要下拉树结构
     *
     * @param categories 插件种类列表
     * @return 下拉树结构列表
     */
    public List<TreeSelect> buildCategoryTreeSelect(List<SysCategory> categories);

    /**
     * 根据插件种类ID查询信息
     *
     * @param categoryId 插件种类ID
     * @return 插件种类信息
     */
    public SysCategory selectCategoryById(Long categoryId);

    /**
     * 根据ID查询所有子种类（正常状态）
     *
     * @param categoryId 插件种类ID
     * @return 子种类数
     */
    public int selectNormalChildrenCategoryById(Long categoryId);

    /**
     * 是否存在子节点
     *
     * @param categoryId 插件种类ID
     * @return 结果
     */
    public boolean hasChildByCategoryId(Long categoryId);

    /**
     * 查询插件种类是否存在插件
     *
     * @param categoryId 插件种类ID
     * @return 结果 true 存在 false 不存在
     */
    public boolean checkCategoryExistPlugin(Long categoryId);

    /**
     * 校验插件种类名称是否唯一
     *
     * @param category 插件种类信息
     * @return 结果
     */
    public String checkCategoryNameUnique(SysCategory category);

    /**
     * 校验插件种类是否有数据权限
     *
     * @param categoryId 插件种类id
     */
    public void checkCategoryDataScope(Long categoryId);

    /**
     * 新增保存插件种类信息
     *
     * @param category 插件种类信息
     * @return 结果
     */
    public int insertDept(SysCategory category);

    /**
     * 修改保存插件种类信息
     *
     * @param category 插件种类信息
     * @return 结果
     */
    public int updateCategory(SysCategory category);

    /**
     * 删除插件种类管理信息
     *
     * @param categoryId 插件种类ID
     * @return 结果
     */
    public int deleteDeptById(Long categoryId);

}
