package com.tbyf.his.web.controller.dataImport;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tbyf.his.common.annotation.IgnoreWebSecurity;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.domain.param.UploadExcelParam;
import com.tbyf.his.web.dataImport.entity.ExcelData;
import com.tbyf.his.web.dataImport.service.ExcelDataService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;

/**
 * @author lzz
 * @date 2023/2/16 15:30
 */
@RestController
@Api(tags = "excel文件接口")
@RequestMapping("/data/excel")
@Slf4j
public class ExcelDataController {

    @Autowired
    private ExcelDataService excelDataService;

    @IgnoreWebSecurity
    @GetMapping("/download/template")
    @ApiOperation("模板下载")
    public void downloadTemplate(HttpServletResponse response,
                                 @RequestParam String excelId) {
        final ExcelData excel = excelDataService.getById(excelId);
        if (excel != null) {
            try (OutputStream os = response.getOutputStream()) {
                os.write(excel.getFile());
                os.flush();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @IgnoreWebSecurity
    @GetMapping("/download/template/filename")
    @ApiOperation("获取模板文件名")
    public AjaxResult getTemplateFileName(@RequestParam String excelId) {
        final ExcelData excel = excelDataService.getOne(
                Wrappers.lambdaQuery(ExcelData.class)
                        .select(ExcelData::getFileName)
                        .eq(ExcelData::getId, excelId)
        );
        if (excel != null) {
            return AjaxResult.success(excel);
        } else {
            return AjaxResult.error("未查询到指定的模板文件");
        }
    }

    @SneakyThrows
    @IgnoreWebSecurity
    @PostMapping("/upload")
    @ApiOperation("文件导入")
    public AjaxResult bindRule(UploadExcelParam param) {
        if (StringUtils.equals(param.getType(), "1")) {
            ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                    .eq(ExcelData::getTemplateId, param.getTemplateId())
                    .eq(ExcelData::getType, "1"), false);
            if (excelData == null) {
                excelData = new ExcelData();
                excelData.setType("1");
                excelData.setTemplateId(param.getTemplateId());
                excelData.setYear(param.getYear());
                excelData.setOrgName(param.getOrgName());
            }
            excelData.setFile(param.getFile().getBytes());
            excelData.setFileName(param.getFile().getOriginalFilename());
            excelDataService.saveOrUpdate(excelData);
        } else if (StringUtils.equals(param.getType(), "2")) {
            ExcelData excelData = excelDataService.getOne(Wrappers.lambdaQuery(ExcelData.class)
                    .eq(ExcelData::getTemplateId, param.getTemplateId())
                    .eq(ExcelData::getType, "2"), false);
            if (ObjectUtils.isEmpty(excelData)) {
                excelData = new ExcelData();
                excelData.setFile(param.getFile().getBytes());
                excelData.setFileName(param.getFile().getOriginalFilename());
                excelData.setType("2");
                excelData.setTemplateId(param.getTemplateId());
                excelData.setYear(param.getYear());
                excelData.setOrgName(param.getOrgName());
                excelDataService.save(excelData);
            } else {
                excelData.setFile(param.getFile().getBytes());
                excelData.setFileName(param.getFile().getOriginalFilename());
                excelDataService.updateById(excelData);
            }
        }
        return AjaxResult.success();
    }

}
