package com.tbyf.his.web.controller.print;


import com.tbyf.his.common.annotation.Log;
import com.tbyf.his.common.core.controller.BaseController;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.core.page.TableDataInfo;
import com.tbyf.his.common.enums.BusinessType;
import com.tbyf.his.common.utils.poi.ExcelUtil;
import com.tbyf.his.print.domain.PrintMetadata;
import com.tbyf.his.print.service.IPrintMetadataService;
import io.swagger.annotations.Api;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 数据元信息Controller
 *
 * @author x
 * @date 2022-02-25
 */
@Api(tags = "打印模板-数据元")
@RestController
@RequestMapping("/print/metadata")
public class PrintMetadataController extends BaseController {
    @Autowired
    private IPrintMetadataService printMetadataService;

    /**
     * 查询数据元信息列表
     */
//    @PreAuthorize("@ss.hasPermi('metadata:metadata:list')")
    @GetMapping("/list")
    public TableDataInfo list(PrintMetadata printMetadata) {
        startPage();
        List<PrintMetadata> list = printMetadataService.selectPrintMetadataList(printMetadata);
        return getDataTable(list);
    }

    /**
     * 导出数据元信息列表
     */
//    @PreAuthorize("@ss.hasPermi('metadata:metadata:export')")
    @Log(title = "数据元信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, PrintMetadata printMetadata) {
        List<PrintMetadata> list = printMetadataService.selectPrintMetadataList(printMetadata);
        ExcelUtil<PrintMetadata> util = new ExcelUtil<PrintMetadata>(PrintMetadata.class);
        util.exportExcel(response, list, "数据元信息数据");
    }

    /**
     * 获取数据元信息详细信息
     */
//    @PreAuthorize("@ss.hasPermi('metadata:metadata:query')")
    @GetMapping(value = "/{metadataId}")
    public AjaxResult getInfo(@PathVariable("metadataId") Long metadataId) {
        return AjaxResult.success(printMetadataService.selectPrintMetadataByMetadataId(metadataId));
    }

    /**
     * 新增数据元信息
     */
//    @PreAuthorize("@ss.hasPermi('metadata:metadata:add')")
    @Log(title = "数据元信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody PrintMetadata printMetadata) {
        return toAjax(printMetadataService.insertPrintMetadata(printMetadata));
    }

    /**
     * 修改数据元信息
     */
//    @PreAuthorize("@ss.hasPermi('metadata:metadata:edit')")
    @Log(title = "数据元信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody PrintMetadata printMetadata) {
        return toAjax(printMetadataService.updatePrintMetadata(printMetadata));
    }

    /**
     * 删除数据元信息
     */
//    @PreAuthorize("@ss.hasPermi('metadata:metadata:remove')")
    @Log(title = "数据元信息", businessType = BusinessType.DELETE)
    @DeleteMapping("/{metadataIds}")
    public AjaxResult remove(@PathVariable Long[] metadataIds) {
        return toAjax(printMetadataService.deletePrintMetadataByMetadataIds(metadataIds));
    }
}
