package com.tbyf.his.web.dataImport.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.DataImportUtils;
import com.tbyf.his.web.dataImport.domain.param.QueryFieldParam;
import com.tbyf.his.web.dataImport.domain.vo.DataFieldVO;
import com.tbyf.his.web.dataImport.entity.DataField;
import com.tbyf.his.web.dataImport.entity.MetaField;
import com.tbyf.his.web.dataImport.mapper.DataFieldMapper;
import com.tbyf.his.web.dataImport.service.DataFieldService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;

/**
 * @author lzz
 * @date 2023/2/7 11:24
 */
@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class DataFieldServiceImpl extends ServiceImpl<DataFieldMapper, DataField> implements DataFieldService {

    @Autowired
    private DataFieldMapper dataFieldMapper;

    @Override
    public Page<DataFieldVO> queryField(QueryFieldParam param) {
        final Page<DataFieldVO> page = Page.of(param.getPageNum(), param.getPageSize());
        return (Page<DataFieldVO>) dataFieldMapper.queryField(page, param);
    }

    @Override
    public void fieldMatch(List<MetaField> list, DataField field, List<DataField> fieldMatchList) {
        // 先查询元字段里面有没有相互匹配的
        final Optional<MetaField> first = list.stream().filter(item -> {
            if (StringUtils.isNotBlank(item.getFieldComment())) {
                return field.getTitle().contains(item.getFieldComment());
            }
            return false;
        }).findFirst();
        if (first.isPresent()) {
            field.setField(first.get().getId());
            return;
        }
        if (!CollectionUtils.isEmpty(fieldMatchList)) {
            fieldMatchList.forEach(item -> {
                item.setRatio(item.getSimilarityRatio(field));
            });
            final Optional<DataField> max = fieldMatchList.stream().max(Comparator.comparing(DataField::getRatio));
            if (max.isPresent()) {
                if (max.get().getRatio() > 2.2) {
                    field.setField(max.get().getId());
                    return;
                }
            }
        }
        list.forEach(item -> {
            if (StringUtils.isNotBlank(field.getTitle()) && StringUtils.isNotBlank(item.getFieldComment())) {
                item.setRatio(DataImportUtils.getSimilarityRatio(field.getTitle(), item.getFieldComment()));
            }
        });
        final Optional<MetaField> max = list.stream().max(Comparator.comparing(MetaField::getRatio));
        if (max.isPresent()) {
            if (max.get().getRatio() > 0.5) {
                field.setField(max.get().getId());
            }
        }
    }

    @Override
    public List<DataField> listFieldMatchList(String templateId) {
        return dataFieldMapper.listFieldMatchList(templateId);
    }
}
