package com.tbyf.his.closeloop.service.impl;

import com.alibaba.fastjson.JSON;
import com.tbyf.his.closeloop.domain.CloseLoopManuInfo;
import com.tbyf.his.closeloop.mapper.CloseLoopMapper;
import com.tbyf.his.closeloop.service.CloseLoopService;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

/**
 * 闭环管理
 */
@Service
public class CloseLoopServiceImpl implements CloseLoopService {
    @Resource
    private CloseLoopMapper closeLoopMapper;

    /**
     * 查询闭环管理树形信息
     *
     * @return
     */
    @Override
    public List<CloseLoopManuInfo> queryCloseLoopManu() {
        List<CloseLoopManuInfo> closeLoopManuInfos = closeLoopMapper.queryCloseLoopManu();
        for (int i = 0; i < closeLoopManuInfos.size(); i++) {
            Collections.sort(closeLoopManuInfos.get(i).getChildren(), new Comparator<CloseLoopManuInfo>() {
                @Override
                public int compare(CloseLoopManuInfo o1, CloseLoopManuInfo o2) {
                    if (o1.getNodeId() != null && o2.getNodeId() != null) {
                        return o1.getNodeId().intValue() - o2.getNodeId().intValue();
                    } else {
                        return 1;
                    }

                }
            });
        }
        System.out.println(closeLoopManuInfos);
        return closeLoopManuInfos;
    }

    /**
     * 插入闭环管理信息
     *
     * @param closeLoopManuInfo
     * @return
     */
    @Override
    public int saveCloseLoop(CloseLoopManuInfo closeLoopManuInfo) {
        int i = closeLoopMapper.saveCloseLoop(closeLoopManuInfo);
        return i;
    }

    /**
     * 修改闭环管理信息
     *
     * @param closeLoopManuInfo
     * @return
     */
    @Override
    public int updateCloseLoop(CloseLoopManuInfo closeLoopManuInfo) {
        System.out.println(closeLoopManuInfo.getApiParam());
        int i = closeLoopMapper.updateCloseLoop(closeLoopManuInfo);
        return i;
    }

    /**
     * 查询流程下节点信息
     *
     * @param closeLoopManuInfo
     * @return
     */
    @Override
    public List<CloseLoopManuInfo> queryNodeInfo(CloseLoopManuInfo closeLoopManuInfo) {
        List<CloseLoopManuInfo> nodeInfos = closeLoopMapper.queryNodeInfo(closeLoopManuInfo);
        return nodeInfos;
    }

    /**
     * 保存闭环流程流程图json
     *
     * @param closeLoopManuInfo
     * @return
     */
    @Override
    public int saveProcessFlow(CloseLoopManuInfo closeLoopManuInfo) {
        int i = closeLoopMapper.saveProcessFlow(closeLoopManuInfo);
        return i;
    }

    /**
     * 获取闭环流程流程图json
     *
     * @param closeLoopManuInfo
     * @return
     */
    @Override
    public String queryProcessFlow(CloseLoopManuInfo closeLoopManuInfo) {
        List<CloseLoopManuInfo> closeLoopManuInfos = closeLoopMapper.queryProcessFlow(closeLoopManuInfo);
        if (CollectionUtils.isEmpty(closeLoopManuInfos) || closeLoopManuInfos.get(0).getSetProcess() == null || closeLoopManuInfos.get(0).getSetProcess() == "") {
            return "";
        }
        Map<String, List<Map<String, Object>>> map = JSON.parseObject(closeLoopManuInfos.get(0).getSetProcess(), Map.class);
        List<CloseLoopManuInfo> child = closeLoopManuInfos.get(0).getChildren();

        for (int i = 0; i < map.get("node").size(); i++) {
            for (int j = 0; j < child.size(); j++) {
                if (Long.parseLong(map.get("node").get(i).get("nodeId").toString()) == child.get(j).getId()) {
                    map.get("node").get(i).put("apiParam", child.get(j).getApiParam());
                }
            }
        }

        String jsonString = JSON.toJSONString(map);
        return jsonString;
    }

    /**
     * 查询流程信息列表
     *
     * @return
     */
    @Override
    public List<CloseLoopManuInfo> queryProcessInfo() {
        return closeLoopMapper.queryProcessInfo();
    }

    @Override
    public int updateDelFlag(CloseLoopManuInfo closeLoopManuInfo) {
        int i = closeLoopMapper.updateDelFlag(closeLoopManuInfo);
        CloseLoopManuInfo closed = new CloseLoopManuInfo();
        closed.setId(closeLoopManuInfo.getParentId());
        closed.setSetProcess(closeLoopManuInfo.getSetProcess());
        if (i > 0) {
            int j = closeLoopMapper.updateCloseLoop(closed);
        }
        return 1;
    }


}
