package com.tbyf.his.configuration.service.impl;

import java.util.List;

import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.configuration.domain.StConfigDetail;
import com.tbyf.his.configuration.mapper.StConfigDetailMapper;
import com.tbyf.his.configuration.service.IStConfigDetailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 组件Service业务层处理
 *
 * @author guopx
 * @date 2022-05-16
 */
@Service
public class StConfigDetailServiceImpl implements IStConfigDetailService {
    @Autowired
    private StConfigDetailMapper stConfigDetailMapper;

    /**
     * 查询组件
     *
     * @param id 组件主键
     * @return 组件
     */
    @Override
    public StConfigDetail selectStConfigDetailById(Long id) {
        return stConfigDetailMapper.selectStConfigDetailById(id);
    }

    /**
     * 查询组件列表
     *
     * @param stConfigDetail 组件
     * @return 组件
     */
    @Override
    public List<StConfigDetail> selectStConfigDetailList(StConfigDetail stConfigDetail) {
        return stConfigDetailMapper.selectStConfigDetailList(stConfigDetail);
    }

    /**
     * 新增组件
     *
     * @param stConfigDetail 组件
     * @return 结果
     */
    @Override
    public int insertStConfigDetail(StConfigDetail stConfigDetail) {
        stConfigDetail.setCreateTime(DateUtils.getNowDate());
        return stConfigDetailMapper.insertStConfigDetail(stConfigDetail);
    }

    /**
     * 修改组件
     *
     * @param stConfigDetail 组件
     * @return 结果
     */
    @Override
    public int updateStConfigDetail(StConfigDetail stConfigDetail) {
        stConfigDetail.setUpdateTime(DateUtils.getNowDate());
        return stConfigDetailMapper.updateStConfigDetail(stConfigDetail);
    }

    /**
     * 批量删除组件
     *
     * @param ids 需要删除的组件主键
     * @return 结果
     */
    @Override
    public int deleteStConfigDetailByIds(Long[] ids) {
        return stConfigDetailMapper.deleteStConfigDetailByIds(ids);
    }

    /**
     * 删除组件信息
     *
     * @param id 组件主键
     * @return 结果
     */
    @Override
    public int deleteStConfigDetailById(Long id) {
        return stConfigDetailMapper.deleteStConfigDetailById(id);
    }
}
