package com.tbyf.his.web.controller.dataImport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.tbyf.his.common.annotation.IgnoreWebSecurity;
import com.tbyf.his.common.core.domain.AjaxResult;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.common.utils.bean.BeanUtils;
import com.tbyf.his.web.dataImport.domain.param.*;
import com.tbyf.his.web.dataImport.entity.DataDict;
import com.tbyf.his.web.dataImport.entity.DataImportTemplate;
import com.tbyf.his.web.dataImport.service.DataDictService;
import com.tbyf.his.web.dataImport.service.DataImportTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/2/7 10:42
 */
@RestController
@Api(tags = "数据导入接口")
@RequestMapping("/dataImport")
@Slf4j
public class DataImportController {

    @Autowired
    private DataImportTemplateService dataImportService;

    @Autowired
    private DataDictService dictService;

    @IgnoreWebSecurity
    @GetMapping("/template")
    @ApiOperation("模板查询")
    public AjaxResult queryTemplate(@Validated QueryTemplateParam param) {
        final LambdaQueryWrapper<DataImportTemplate> wrapper = Wrappers.lambdaQuery(DataImportTemplate.class)
                .eq(DataImportTemplate::getYear, param.getYear());
        return AjaxResult.success(dataImportService.list(wrapper));
    }

    @IgnoreWebSecurity
    @PostMapping("/template")
    @ApiOperation("模板新增")
    public AjaxResult addTemplate(@RequestBody @Validated AddTemplateParam param) {
        DataImportTemplate template = new DataImportTemplate();
        BeanUtils.copyProperties(param, template);
        template.initAdd();
        dataImportService.save(template);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @PutMapping("/template")
    @ApiOperation("修改模板")
    public AjaxResult updateTemplate(@RequestBody @Validated UpdateTemplateParam param) {
        DataImportTemplate template = new DataImportTemplate();
        BeanUtils.copyProperties(param, template);
        template.initAdd();
        dataImportService.updateById(template);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @DeleteMapping("/template")
    @ApiOperation("删除模板")
    public AjaxResult deleteTemplate(@RequestParam String templateId) {
        dataImportService.removeById(templateId);
        //TODO 需要删除字段以及其字段关联的规则与其它数据
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @GetMapping("/dict")
    @ApiOperation("字典查询")
    public AjaxResult queryDict(@RequestParam String type) {
        final LambdaQueryWrapper<DataDict> wrapper = Wrappers.lambdaQuery(DataDict.class)
                .eq(DataDict::getType, type);
        final List<Map<String, String>> list = dictService.list(wrapper).stream().map(item -> {
            String json = item.getRemarks();
            item.setRemarks(null);
            final Map<String, String> map = BeanUtils.getFieldValueMap(item);
            if (StringUtils.isNotBlank(json)) {
                try {
                    final JSONObject object = JSON.parseObject(json);
                    object.forEach((key, value) -> {
                        map.put(key, (String) value);
                    });
                } catch (Exception ignore) {
                }
            }
            return map;
        }).collect(Collectors.toList());
        return AjaxResult.success(list);
    }

    @IgnoreWebSecurity
    @PostMapping("/dict")
    @ApiOperation("新增字典")
    public AjaxResult addDict(@RequestBody AddDictParam param) {
        DataDict dict = new DataDict();
        BeanUtils.copyProperties(param, dict);
        dictService.save(dict);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @PutMapping("/dict")
    @ApiOperation("修改字典")
    public AjaxResult updateDict(@RequestBody @Validated UpdateDictParam param) {
        DataDict template = new DataDict();
        BeanUtils.copyProperties(param, template);
        dictService.updateById(template);
        return AjaxResult.success();
    }

    @IgnoreWebSecurity
    @DeleteMapping("/dict")
    @ApiOperation("删除字典")
    public AjaxResult deleteDict(@RequestParam String dictId) {
        dictService.removeById(dictId);
        return AjaxResult.success();
    }

}
