package com.tbyf.his.web.dataImport.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author lzz
 * @date 2023/1/10 15:36
 */

@Data
@Accessors(chain = true)
@TableName(value = "data_dict", autoResultMap = true)
@ApiModel(value = "数据字典", description = "数据字典")
public class DataDict implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "模板ID")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;
    @ApiModelProperty(value = "字典类型")
    @TableField("type")
    private String type;

    @ApiModelProperty(value = "展示")
    @TableField("label")
    private String label;

    @ApiModelProperty(value = "数据值")
    @TableField("value")
    private String value;

    @ApiModelProperty(value = "备注")
    @TableField("remarks")
    private String remarks;

}
