package com.tbyf.his.system.vo;

import com.tbyf.his.common.core.domain.model.MyKeyValue;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.util.List;

/**
 * @author: fr
 * @date: 2022年08月19日 10:34
 * <p>
 * 构建动态sql需要的参数配置
 */
@Data
@Builder
public class DynamicSqlData {
    /**
     * 数据源id
     */
    private Long datasourceId;
    /**
     * 表名
     */
    private String tableName;

    /**
     * 主键字段
     */
    private String primaryKey;
    /**
     * 主键信息
     */
    private MyKeyValue primaryParam;
    /**
     * 查询字段
     */
    private List<String> queryParam;
    /**
     * 查询条件
     */
    private List<MyKeyValue> whereParam;
    /**
     * 新增/修改数据
     */
    private List<MyKeyValue> dataParam;
    /**
     * 当前页
     */
    private Integer pageNum;
    /**
     * 每页条数
     */
    private Integer pageSize;

    @Tolerate
    public DynamicSqlData() {
    }
}
