package com.tbyf.his.configuration.service.impl;

import java.util.List;

import com.tbyf.his.common.utils.DateUtils;
import com.tbyf.his.configuration.domain.StConfig;
import com.tbyf.his.configuration.mapper.StConfigMapper;
import com.tbyf.his.configuration.service.IStConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * searchTable组件配置Service业务层处理
 *
 * @author guopx
 * @date 2022-05-16
 */
@Service
public class StConfigServiceImpl implements IStConfigService {
    @Autowired
    private StConfigMapper stConfigMapper;

    /**
     * 查询searchTable组件配置
     *
     * @param id searchTable组件配置主键
     * @return searchTable组件配置
     */
    @Override
    public StConfig selectStConfigById(Long id) {
        return stConfigMapper.selectStConfigById(id);
    }

    /**
     * 查询searchTable组件配置列表
     *
     * @param stConfig searchTable组件配置
     * @return searchTable组件配置
     */
    @Override
    public List<StConfig> selectStConfigList(StConfig stConfig) {
        return stConfigMapper.selectStConfigList(stConfig);
    }

    /**
     * 新增searchTable组件配置
     *
     * @param stConfig searchTable组件配置
     * @return 结果
     */
    @Override
    public int insertStConfig(StConfig stConfig) {
        stConfig.setCreateTime(DateUtils.getNowDate());
        return stConfigMapper.insertStConfig(stConfig);
    }

    /**
     * 修改searchTable组件配置
     *
     * @param stConfig searchTable组件配置
     * @return 结果
     */
    @Override
    public int updateStConfig(StConfig stConfig) {
        stConfig.setUpdateTime(DateUtils.getNowDate());
        return stConfigMapper.updateStConfig(stConfig);
    }

    /**
     * 批量删除searchTable组件配置
     *
     * @param ids 需要删除的searchTable组件配置主键
     * @return 结果
     */
    @Override
    public int deleteStConfigByIds(Long[] ids) {
        return stConfigMapper.deleteStConfigByIds(ids);
    }

    /**
     * 删除searchTable组件配置信息
     *
     * @param id searchTable组件配置主键
     * @return 结果
     */
    @Override
    public int deleteStConfigById(Long id) {
        return stConfigMapper.deleteStConfigById(id);
    }
}
