package com.tbyf.his.web.dataImport.service;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.service.IService;
import com.tbyf.his.web.dataImport.domain.param.QueryTemplateParam;
import com.tbyf.his.web.dataImport.domain.vo.FieldErrorVo;
import com.tbyf.his.web.dataImport.domain.vo.TemplateVO;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import com.tbyf.his.web.dataImport.entity.DataRule;
import com.tbyf.his.web.dataImport.entity.DataTemplate;

import java.util.List;
import java.util.concurrent.CompletableFuture;

/**
 * @author lzz
 * @date 2023/2/7 11:23
 */

public interface DataTemplateService extends IService<DataTemplate> {

    /**
     * 查询模板信息
     *
     * @param param
     * @return
     */
    List<TemplateVO> queryTemplate(QueryTemplateParam param);

    DbType getDbType(String dataSourceId);

    /**
     * 获取综合校验对象
     *
     * @param id
     * @return
     */
    List<VerifyVO> getVerify(String id);

    /**
     * 获取模板校验规则
     *
     * @param templateId
     * @return
     */
    List<DataRule> getAllRule(String templateId);

    /**
     * 获取物理表的错误字段
     * @param fieldErrorVos
     * @param tableName
     * @return
     */
    public CompletableFuture<List<FieldErrorVo>> getTableFieldError(List<FieldErrorVo> fieldErrorVos, String tableName);

    /**
     * 同步异常字段
     * @param fieldType
     * @param fieldName
     * @param tableName
     */
    public void syncFieldError(String fieldType, String fieldName, String tableName);
}
