package com.tbyf.his.web.dataImport.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.tbyf.his.adapter.task.StringColumnRowMapper;
import com.tbyf.his.common.annotation.DataSource;
import com.tbyf.his.common.annotation.Excel;
import com.tbyf.his.common.core.text.StrFormatter;
import com.tbyf.his.common.enums.DataSourceType;
import com.tbyf.his.common.exception.base.BaseException;
import com.tbyf.his.common.utils.StringUtils;
import com.tbyf.his.web.dataImport.DataImportUtils;
import com.tbyf.his.web.dataImport.core.*;
import com.tbyf.his.web.dataImport.domain.vo.ExcelVO;
import com.tbyf.his.web.dataImport.domain.vo.VerifyVO;
import com.tbyf.his.web.dataImport.entity.DataDict;
import com.tbyf.his.web.dataImport.entity.DataRule;
import com.tbyf.his.web.dataImport.entity.DataTemplate;
import com.tbyf.his.web.dataImport.entity.ExcelData;
import com.tbyf.his.web.dataImport.mapper.ExcelDataMapper;
import com.tbyf.his.web.dataImport.mapper.MetaFieldMapper;
import com.tbyf.his.web.dataImport.service.DataDictService;
import com.tbyf.his.web.dataImport.service.DataSourceService;
import com.tbyf.his.web.dataImport.service.DataTemplateService;
import com.tbyf.his.web.dataImport.service.ExcelDataService;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.Zip64Mode;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.concurrent.*;
import java.util.stream.Collectors;

/**
 * @author lzz
 * @date 2023/2/7 11:24
 */
@Slf4j
@Service
@DataSource(DataSourceType.MASTER)
public class ExcelDataServiceImpl extends ServiceImpl<ExcelDataMapper, ExcelData> implements ExcelDataService {

    @Autowired
    private DataTemplateService dataTemplateService;

    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    private DataDictService dataDictService;

    @Autowired
    private MetaFieldMapper metaFieldMapper;

    @Autowired
    @Qualifier("threadPoolTaskExecutor")
    private Executor executor;

    @Override
    public void analyzeExport(ExcelData excelData, HttpServletResponse response) {
        // 查询出所有字段配置
        final DataTemplate template = dataTemplateService.getById(excelData.getTemplateId());
        List<VerifyVO> verifyList = dataTemplateService.getVerify(template.getId());
        // 拼接sql查询数据
        String sqlTemplate = "SELECT {}  FROM {} WHERE YEAROOFDATARECORD = '{}' ORDER BY ROWCODE";
        String fieldSql = verifyList.stream().map(VerifyVO::getFieldName).collect(Collectors.joining(","));
        List<Map<String, String>> dataList;
        ExcelVO[] excels;
        try {
            DataSourceService.switchDb(template.getDataSourceId());
            // 需要先清空临时表的数据,按照年份
            dataList = jdbcTemplate.query(StrFormatter.format(sqlTemplate, fieldSql, template.getTableName() + "_TEMP", template.getYear() + "年"), new StringColumnRowMapper());
            // 解析数据到values里面
            for (VerifyVO verifyVO : verifyList) {
                dataList.forEach(map -> {
                    String s = map.get(verifyVO.getFieldName());
                    verifyVO.addValue(StringUtils.isBlank(s) ? StringUtils.EMPTY : s);
                });
            }
            // 获取每一步的核心机构等信息
            excels = new ExcelVO[dataList.size()];
            for (int e = 0; e < dataList.size(); e++) {
                excels[e] = new ExcelVO();
                excels[e].setOrgType(template.getOrgName());
                String orgName = dataList.get(e).get("ORG_NAME");
                String orgCode = dataList.get(e).get("ORG_CODE");
                String uniformCreditNumber = dataList.get(e).get("UNIFORM_CREDIT_NUMBER");
                String areaNumberCode = dataList.get(e).get("AREA_NUMBER_CODE");
                excels[e].setOrgName(StringUtils.isBlank(orgName) ? StringUtils.EMPTY : orgName);
                excels[e].setOrgCode(StringUtils.isBlank(orgCode) ? StringUtils.EMPTY : orgCode);
                excels[e].setUnifiedCode(StringUtils.isBlank(uniformCreditNumber) ? StringUtils.EMPTY : uniformCreditNumber);
                excels[e].setAreaCode(StringUtils.isBlank(areaNumberCode) ? StringUtils.EMPTY : areaNumberCode);
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        } finally {
            DataSourceService.switchDefault();
        }
        // 第二步进行数据校验
        verifyList.stream()
                .filter(item -> !CollectionUtils.isEmpty(item.getValues()) && !CollectionUtils.isEmpty(item.getRules()))
                .forEach(item -> {
                    for (int i = 0; i < item.getValues().size(); i++) {
                        for (int j = 0; j < item.getRules().size(); j++) {
                            final RuleVO vo = item.getRules().get(j);
                            vo.setValue(item.getValues().get(i));
                            // 置空错误信息
                            vo.setResult(null);
                            // TODO 特殊数据无需做错误校验
                            if (DiConstants.WHITE.contains(vo.getValue())) {
                                break;
                            }
                            final RuleValidator validator = DiConfig.getValidator(vo.getMode());
                            validator.validate(vo);
                            if (StringUtils.isNotBlank(vo.getResult())) {
                                ExcelVO excelVO = new ExcelVO();
                                BeanUtils.copyProperties(excels[i], excelVO);
                                excelVO.setCode(item.getCode())
                                        .setTitle(item.getTitle())
                                        .setValue(item.getValues().get(i))
                                        .setMessage(vo.getResult());
                                item.addError(excelVO);
                            }
                        }
                    }
                });
        List<ExcelVO> list = new ArrayList<>();
        verifyList.forEach(item -> {
            if (!CollectionUtils.isEmpty(item.getErrors())) {
                list.addAll(item.getErrors());
            }
        });
        // 模板规则的数据校验
        final List<DataRule> allRule = dataTemplateService.getAllRule(template.getId());
        for (DataRule rule : allRule) {
            if (StringUtils.isNotBlank(rule.getContent())) {
                if (StringUtils.equals(rule.getMode(), "逻辑相加")) {
                    final String[] split = rule.getContent().split("=");
                    if (split.length == 2) {
                        String[] leftIds = split[0].split(",");
                        String[] rightIds = split[1].split(",");
                        final List<String> leftList = Arrays.stream(leftIds).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        final List<String> rightList = Arrays.stream(rightIds).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                        if (leftList.size() > 0 && rightList.size() > 0) {
                            for (int r = 0; r < dataList.size(); r++) {
                                final List<VerifyVO> leftObjs = verifyList.stream().filter(v -> leftList.contains(v.getMetaFieldId())).collect(Collectors.toList());
                                final List<VerifyVO> rightObjs = verifyList.stream().filter(v -> rightList.contains(v.getMetaFieldId())).collect(Collectors.toList());
                                try {
                                    BigDecimal left = new BigDecimal("0");
                                    BigDecimal right = new BigDecimal("0");
                                    for (VerifyVO leftVo : leftObjs) {
                                        try {
                                            left = left.add(new BigDecimal(leftVo.getValues().get(r)));
                                        } catch (Exception ignore) {
                                        }
                                    }
                                    for (VerifyVO rightVo : rightObjs) {
                                        try {
                                            right = right.add(new BigDecimal(rightVo.getValues().get(r)));
                                        } catch (Exception ignore) {
                                        }
                                    }
                                    // 这里需要进行四舍五入的精确位数处理
                                    if (StringUtils.isNotBlank(rule.getRemarks())) {
                                        int scale = Integer.parseInt(rule.getRemarks());
                                        left = left.setScale(scale, RoundingMode.UP);
                                        right = right.setScale(scale, RoundingMode.UP);
                                    }
                                    if (left.compareTo(right) != 0) {
                                        ExcelVO excelVO = new ExcelVO();
                                        BeanUtils.copyProperties(excels[r], excelVO);
                                        excelVO.setMessage("逻辑验证错误,正确公式为:" + getFormula(leftObjs, rightObjs));
                                        leftObjs.addAll(rightObjs);
                                        int finalR = r;
                                        final List<ExcelVO> errList = leftObjs.stream().map(item -> {
                                            final ExcelVO temp = new ExcelVO();
                                            temp.setCode(item.getCode())
                                                    .setAreaCode(excelVO.getAreaCode())
                                                    .setTitle(item.getTitle())
                                                    .setValue(item.getValues().get(finalR));
                                            return temp;
                                        }).collect(Collectors.toList());
                                        final ExcelVO firstVo = errList.get(0);
                                        firstVo.setMessage(excelVO.getMessage()).setOrgName(excelVO.getOrgName())
                                                .setOrgType(excelVO.getOrgType()).setOrgCode(excelVO.getOrgCode())
                                                .setUnifiedCode(excelVO.getUnifiedCode());
                                        list.addAll(errList);
                                    }
                                } catch (Exception e) {
                                    ExcelVO excelVO = new ExcelVO();
                                    BeanUtils.copyProperties(excels[r], excelVO);
                                    excelVO.setMessage("逻辑验证错误,正确公式为:" + getFormula(leftObjs, rightObjs));
                                    leftObjs.addAll(rightObjs);
                                    int finalR = r;
                                    final List<ExcelVO> errList = leftObjs.stream().map(item -> {
                                        final ExcelVO temp = new ExcelVO();
                                        temp.setCode(item.getCode())
                                                .setAreaCode(excelVO.getAreaCode())
                                                .setTitle(item.getTitle())
                                                .setValue(item.getValues().get(finalR));
                                        return temp;
                                    }).collect(Collectors.toList());
                                    final ExcelVO firstVo = errList.get(0);
                                    firstVo.setMessage(excelVO.getMessage()).setOrgName(excelVO.getOrgName())
                                            .setOrgType(excelVO.getOrgType()).setOrgCode(excelVO.getOrgCode())
                                            .setUnifiedCode(excelVO.getUnifiedCode());
                                    list.addAll(errList);
                                }
                            }
                        }
                    }
                }
            }
        }
        // 第四步导出异常excel
        Map<String, List<ExcelVO>> areaMap = list.stream().collect(Collectors.groupingBy(ExcelVO::getAreaCode));
        try (ZipArchiveOutputStream zous = new ZipArchiveOutputStream(response.getOutputStream())) {
            zous.setUseZip64(Zip64Mode.AsNeeded);
            areaMap.forEach((code,excelList)-> {
                final DataDict one = dataDictService.getOne(Wrappers.lambdaQuery(DataDict.class)
                        .eq(DataDict::getType, "area").eq(DataDict::getValue, code), false);
                String fileName = one == null ? code + ".xlsx" : one.getLabel() + ".xlsx";
                ExcelUtil<ExcelVO> util = new ExcelUtil<>(ExcelVO.class);
                util.init(excelList, "异常数据分析", "", Excel.Type.EXPORT);
                util.writeSheet();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    util.getWb().write(baos);
                    IOUtils.closeQuietly(util.getWb());
                    byte[] bytes = baos.toByteArray();
                    ArchiveEntry entry = new ZipArchiveEntry(fileName);
                    zous.putArchiveEntry(entry);
                    zous.write(bytes);
                    zous.closeArchiveEntry();
                    if (baos != null) {
                        baos.close();
                    }
                } catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } catch (IOException e) {
            throw new RuntimeException(e);
        }finally {

        }
    }


    public void analyzeExportOld(ExcelData excelData, HttpServletResponse response) {
        final DataTemplate template = dataTemplateService.getById(excelData.getTemplateId());
        List<VerifyVO> verifyList = dataTemplateService.getVerify(template.getId());
        try (InputStream is = new ByteArrayInputStream(excelData.getFile()); Workbook workbook = WorkbookFactory.create(is)) {
            final Sheet sheet = workbook.getSheetAt(0);
            //final int rows = sheet.getLastRowNum() + 1;
            final Optional<VerifyVO> first = verifyList.stream()
                    .filter(item -> StringUtils.isNotBlank(item.getCoordinate()))
                    .findFirst();
            // 数据长度/条数
            final List<Integer> columnList = DiConfig.getLength(first.get(), sheet);
            final int length = columnList.size();
            // 第一步解析数据到values
            for (int a = 0; a < verifyList.size(); a++) {
                final VerifyVO vo = verifyList.get(a);
                if (StringUtils.isBlank(vo.getCoordinate())) {
                    final String s = DiConfig.getCoordinate(vo, sheet);
                    if (StringUtils.isBlank(s)) {
                        vo.addError(new ExcelVO("没有符合代码与指标名称的字段行", ""));
                        continue;
                    }
                    vo.setCoordinate(s);
                }
                final String[] coords = vo.getCoordinate().split(",");
                // TODO 这里减1的原因是excel表名的行号1实际上的下标为0
                int rowStart = Integer.parseInt(coords[1]) - 1;
                final Row row = sheet.getRow(rowStart);
                for (Integer column : columnList) {
                    try {
                        final Cell cell = row.getCell(column, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                        vo.addValue(DiConfig.getValue(cell));
                    } catch (Exception ignore) {
                    }
                }
            }
            // 获取每一步的核心机构等信息
            ExcelVO[] excels = new ExcelVO[length];
            for (int e = 0; e < length; e++) {
                excels[e] = new ExcelVO();
                excels[e].setOrgType(template.getOrgName());
                for (VerifyVO v : verifyList) {
                    if (StringUtils.equals("ORG_NAME", v.getFieldName())) {
                        excels[e].setOrgName(v.getValues().get(e));
                        continue;
                    }
                    if (StringUtils.equals("ORG_CODE", v.getFieldName())) {
                        excels[e].setOrgCode(v.getValues().get(e));
                        continue;
                    }
                    if (StringUtils.equals("UNIFORM_CREDIT_NUMBER", v.getFieldName())) {
                        excels[e].setUnifiedCode(v.getValues().get(e));
                        continue;
                    }
                }
            }
            // 第二步进行数据校验
            verifyList.stream()
                    .filter(item -> !CollectionUtils.isEmpty(item.getValues()) && !CollectionUtils.isEmpty(item.getRules()))
                    .forEach(item -> {
                        for (int i = 0; i < item.getValues().size(); i++) {
                            for (int j = 0; j < item.getRules().size(); j++) {
                                final RuleVO vo = item.getRules().get(j);
                                vo.setValue(item.getValues().get(i));
                                // 置空错误信息
                                vo.setResult(null);
                                // TODO 特殊数据无需做错误校验
                                if (DiConstants.WHITE.contains(vo.getValue())) {
                                    break;
                                }
                                final RuleValidator validator = DiConfig.getValidator(vo.getMode());
                                validator.validate(vo);
                                if (StringUtils.isNotBlank(vo.getResult())) {
                                    ExcelVO excelVO = new ExcelVO();
                                    BeanUtils.copyProperties(excels[i], excelVO);
                                    excelVO.setCode(item.getCode())
                                            .setTitle(item.getTitle())
                                            .setValue(item.getValues().get(i))
                                            .setMessage(vo.getResult());
                                    item.addError(excelVO);
                                }
                            }
                        }
                    });
            List<ExcelVO> list = new ArrayList<>();
            verifyList.forEach(item -> {
                if (!CollectionUtils.isEmpty(item.getErrors())) {
                    list.addAll(item.getErrors());
                }
            });
            // 模板规则的数据校验
            final List<DataRule> allRule = dataTemplateService.getAllRule(template.getId());
            for (DataRule rule : allRule) {
                if (StringUtils.isNotBlank(rule.getContent())) {
                    if (StringUtils.equals(rule.getMode(), "逻辑相加")) {
                        final String[] split = rule.getContent().split("=");
                        if (split.length == 2) {
                            String[] leftIds = split[0].split(",");
                            String[] rightIds = split[1].split(",");
                            final List<String> leftList = Arrays.stream(leftIds).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                            final List<String> rightList = Arrays.stream(rightIds).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                            if (leftList.size() > 0 && rightList.size() > 0) {
                                for (int r = 0; r < length; r++) {
                                    final List<VerifyVO> leftObjs = verifyList.stream().filter(v -> leftList.contains(v.getMetaFieldId())).collect(Collectors.toList());
                                    final List<VerifyVO> rightObjs = verifyList.stream().filter(v -> rightList.contains(v.getMetaFieldId())).collect(Collectors.toList());
                                    try {
                                        BigDecimal left = new BigDecimal("0");
                                        BigDecimal right = new BigDecimal("0");
                                        for (VerifyVO leftVo : leftObjs) {
                                            try {
                                                left = left.add(new BigDecimal(leftVo.getValues().get(r)));
                                            } catch (Exception ignore) {
                                            }
                                        }
                                        for (VerifyVO rightVo : rightObjs) {
                                            try {
                                                right = right.add(new BigDecimal(rightVo.getValues().get(r)));
                                            } catch (Exception ignore) {
                                            }
                                        }
                                        // 这里需要进行四舍五入的精确位数处理
                                        if (StringUtils.isNotBlank(rule.getRemarks())) {
                                            int scale = Integer.parseInt(rule.getRemarks());
                                            left = left.setScale(scale, RoundingMode.UP);
                                            right = right.setScale(scale, RoundingMode.UP);
                                        }
                                        if (left.compareTo(right) != 0) {
                                            ExcelVO excelVO = new ExcelVO();
                                            BeanUtils.copyProperties(excels[r], excelVO);
                                            excelVO.setMessage("逻辑验证错误,正确公式为:" + getFormula(leftObjs, rightObjs));
                                            leftObjs.addAll(rightObjs);
                                            int finalR = r;
                                            final List<ExcelVO> errList = leftObjs.stream().map(item -> {
                                                final ExcelVO temp = new ExcelVO();
                                                temp.setCode(item.getCode())
                                                        .setTitle(item.getTitle())
                                                        .setValue(item.getValues().get(finalR));
                                                return temp;
                                            }).collect(Collectors.toList());
                                            final ExcelVO firstVo = errList.get(0);
                                            firstVo.setMessage(excelVO.getMessage()).setOrgName(excelVO.getOrgName())
                                                    .setOrgType(excelVO.getOrgType()).setOrgCode(excelVO.getOrgCode())
                                                    .setUnifiedCode(excelVO.getUnifiedCode());
                                            list.addAll(errList);
                                        }
                                    } catch (Exception e) {
                                        ExcelVO excelVO = new ExcelVO();
                                        BeanUtils.copyProperties(excels[r], excelVO);
                                        excelVO.setMessage("逻辑验证错误,正确公式为:" + getFormula(leftObjs, rightObjs));
                                        leftObjs.addAll(rightObjs);
                                        int finalR = r;
                                        final List<ExcelVO> errList = leftObjs.stream().map(item -> {
                                            final ExcelVO temp = new ExcelVO();
                                            temp.setCode(item.getCode())
                                                    .setTitle(item.getTitle())
                                                    .setValue(item.getValues().get(finalR));
                                            return temp;
                                        }).collect(Collectors.toList());
                                        final ExcelVO firstVo = errList.get(0);
                                        firstVo.setMessage(excelVO.getMessage()).setOrgName(excelVO.getOrgName())
                                                .setOrgType(excelVO.getOrgType()).setOrgCode(excelVO.getOrgCode())
                                                .setUnifiedCode(excelVO.getUnifiedCode());
                                        list.addAll(errList);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            // 第三步导入临时表
            String insertSql = "INSERT INTO {}(" + verifyList.stream()
                    .map(VerifyVO::getFieldName).collect(Collectors.joining(","))
                    + ",DORDER,YEAROOFDATARECORD,ROWCODE ) VALUES ({})";
            String[] sqlArr = new String[length];
            for (int i = 0; i < length; i++) {
                StringBuilder sb = new StringBuilder();
                for (VerifyVO v : verifyList) {
                    sb.append(DataImportUtils.getInsertContent(v, i)).append(",");
                }
                sb.append("'").append(DataImportUtils.getNextId()).append("','")
                        .append(template.getYear()).append("年").append("','")
                        .append(DataImportUtils.getNextId()).append("'");
                sqlArr[i] = StrFormatter.format(insertSql, template.getTableName() + "_TEMP", sb);
            }
            try {
                DataSourceService.switchDb(template.getDataSourceId());
                // 需要先清空临时表的数据,按照年份
                jdbcTemplate.execute(StrFormatter.format("DELETE FROM {} WHERE YEAROOFDATARECORD = '{}'"
                        , template.getTableName() + "_TEMP", template.getYear() + "年"));
                jdbcTemplate.batchUpdate(sqlArr);
            } catch (Exception e) {
                throw new RuntimeException(e);
            } finally {
                DataSourceService.switchDefault();
            }
            // 第四步导出异常excel
            ExcelUtil<ExcelVO> util = new ExcelUtil<>(ExcelVO.class);
            util.exportExcel(response, list, "异常数据分析");
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> importData(ExcelData excelData) {
        log.info("开始解析excel数据");
        List<String> errorList = new ArrayList<>();
        long startTime = System.currentTimeMillis();
        final DataTemplate template = dataTemplateService.getById(excelData.getTemplateId());
        // 获取元字段与所有校验对象
        List<VerifyVO> verifyList = dataTemplateService.getVerify(template.getId());
        try {
            DataSourceService.switchDb(template.getDataSourceId());
            verifyList.forEach(item->{
                // 查询数据库字段类型
                if (StrUtil.isNotBlank(item.getFieldType())){
                    String columnType;
                    if (StrUtil.containsIgnoreCase(item.getFieldType(),"NUMBER")) {
                        columnType = metaFieldMapper.selectNumberFieldType(template.getTableName()+"_TEMP", item.getFieldName());
                    } else {
                        columnType = metaFieldMapper.selectFieldType(template.getTableName()+"_TEMP", item.getFieldName());
                    }
                    if (StrUtil.isNotBlank(columnType)){
                        item.setColumnType(columnType);
                    }
                }
            });
        }catch (Exception ignored){}finally {
            DataSourceService.switchDefault();
        }
        try (InputStream is = new ByteArrayInputStream(excelData.getFile()); Workbook workbook = WorkbookFactory.create(is)) {
            final Sheet sheet = workbook.getSheetAt(0);
            final Optional<VerifyVO> first = verifyList.stream()
                    .filter(item -> StringUtils.isNotBlank(item.getCoordinate()))
                    .findFirst();
            // 获取第一个有详细坐标的数据
            // 数据长度/条数  根据这一列的数据来判断一共有多少条数据,并且有数据的列的x轴坐标在哪里
            final List<Integer> columnList = DiConfig.getLength(first.get(), sheet);
            final int length = columnList.size();
            // 第一步解析数据到values
            for (final VerifyVO vo : verifyList) {
                if (StringUtils.isBlank(vo.getCoordinate())) {
                    final String s = DiConfig.getCoordinate(vo, sheet);
                    if (StringUtils.isBlank(s)) {
                        vo.addError(new ExcelVO("没有符合代码与指标名称的字段行", ""));
                        continue;
                    }
                    vo.setCoordinate(s);
                }
                // 整数长度 小数长度 字段长度
                int a = 0, b = 0, c = 0;
                int x = 0, y = 0, z = 0;
                if (StrUtil.containsIgnoreCase(vo.getFieldType(),"number")){
                    String[] split = StrUtil.replaceIgnoreCase(vo.getFieldType(), "number", "")
                            .replaceAll("\\(", "")
                            .replaceAll("\\)", "")
                            .split(",");
                    b = Convert.toInt(split[1]);
                    a = Convert.toInt(split[0]) - b;
                }else if (StringUtils.containsIgnoreCase(vo.getFieldType(), "char")){
                    c = Convert.toInt(StrUtil.replaceIgnoreCase(
                                    StrUtil.replaceIgnoreCase(vo.getFieldType(), "varchar2", ""), "varchar", "")
                            .replaceAll("\\(", "")
                            .replaceAll("\\)", ""));
                }
                if (StrUtil.containsIgnoreCase(vo.getColumnType(),"number")){
                    String[] split = StrUtil.replaceIgnoreCase(vo.getColumnType(), "number", "")
                            .replaceAll("\\(", "")
                            .replaceAll("\\)", "")
                            .split(",");
                    y = Convert.toInt(split[1]);
                    x = Convert.toInt(split[0]) - b;
                }else if (StringUtils.containsIgnoreCase(vo.getColumnType(), "char")){
                    z = Convert.toInt(StrUtil.replaceIgnoreCase(
                                    StrUtil.replaceIgnoreCase(vo.getColumnType(), "varchar2", ""), "varchar", "")
                            .replaceAll("\\(", "")
                            .replaceAll("\\)", ""));
                }

                final String[] coords = vo.getCoordinate().split(",");
                // TODO 这里减1的原因是excel表名的行号1实际上的下标为0
                int rowStart = Integer.parseInt(coords[1]) - 1;
                final Row row = sheet.getRow(rowStart);
                for (Integer column : columnList) {
                    final Cell cell = row.getCell(column, Row.MissingCellPolicy.RETURN_BLANK_AS_NULL);
                    String cellValue = DiConfig.getValue(cell);
                    if (StrUtil.containsIgnoreCase(vo.getFieldType(),"number")){
                        // 如果是数字
                        // 计算整数长度in  小数长度de
                        int in = cellValue.indexOf(".");
                        if (in == -1){
                            in = cellValue.length();
                        }
                        int de = cellValue.length() == in ? 0 : cellValue.length() - in - 1;
                        if ( in > a || de > b){
                            errorList.add(StrFormatter.format("字段数据:[{}],字段类型:[{}],字段名称:[{}],数据位置:[{}],数据不符合元字段精度要求",
                                    cellValue, vo.getFieldType(), vo.getFieldName(),new CellReference(cell.getRowIndex(),cell.getColumnIndex()).formatAsString()));
                        }
                        if ( in > x || de > y){
                            errorList.add(StrFormatter.format("字段数据:[{}],字段类型:[{}],字段名称:[{}],数据位置:[{}],数据不符合数据库精度要求",
                                    cellValue, vo.getColumnType(), vo.getFieldName(),new CellReference(cell.getRowIndex(),cell.getColumnIndex()).formatAsString()));
                        }
                        if (StringUtils.equals("",cellValue) || StringUtils.equals("-",cellValue)){
                            cellValue = "0";
                        }else if (!NumberUtils.isCreatable(cellValue)){
                            errorList.add(StrFormatter.format("字段数据:[{}],字段类型:[{}],字段名称:[{}],数据位置:[{}],不是合法的数字",
                                    cellValue, vo.getFieldType(), vo.getFieldName(),new CellReference(cell.getRowIndex(),cell.getColumnIndex()).formatAsString()));
                        }
                    }else if (StrUtil.containsIgnoreCase(vo.getFieldType(),"char")){
                        if (c < cellValue.length() * 3) {
                            errorList.add( StrFormatter.format("字段数据:[{}],字段类型:[{}],字段名称:[{}],数据位置:[{}],数据长度超过元字段限制",
                                    cellValue, vo.getFieldType(), vo.getFieldName(),new CellReference(cell.getRowIndex(),cell.getColumnIndex()).formatAsString()));
                        }
                        if (z < cellValue.length() * 3) {
                            errorList.add( StrFormatter.format("字段数据:[{}],字段类型:[{}],字段名称:[{}],数据位置:[{}],数据长度超过数据库字段限制",
                                    cellValue, vo.getColumnType(), vo.getFieldName(),new CellReference(cell.getRowIndex(),cell.getColumnIndex()).formatAsString()));
                        }
                    }
                    vo.addValue(cellValue);
                }
            }
            log.info("解析Excel数据用时:[{}]", System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
            // 直接导入临时表
            String insertSql = "INSERT INTO {}(" + verifyList.stream()
                    .map(VerifyVO::getFieldName).collect(Collectors.joining(","))
                    + ",DORDER,YEAROOFDATARECORD,ROWCODE ) VALUES ({})";
            //String[] sqlArr = new String[length];
            List<String> sqlList = new ArrayList<>(length + 100);
            for (int i = 0; i < length; i++) {
                StringBuilder sb = new StringBuilder();
                for (VerifyVO v : verifyList) {
                    sb.append(DataImportUtils.getInsertContent(v, i)).append(",");
                }
                sb.append("'").append(DataImportUtils.getNextId()).append("','")
                        .append(template.getYear()).append("年").append("','")
                        .append(DataImportUtils.getNextId()).append("'");
                sqlList.add( StrFormatter.format(insertSql, template.getTableName() + "_TEMP", sb));
                //sqlArr[i] = StrFormatter.format(insertSql, template.getTableName() + "_TEMP", sb);
            }
            try {
                if(!CollectionUtils.isEmpty(errorList)){
                    return errorList;
                }
                DataSourceService.switchDb(template.getDataSourceId());
                // 需要先清空临时表的数据,按照年份
                jdbcTemplate.execute(StrFormatter.format("DELETE FROM {} WHERE YEAROOFDATARECORD = '{}'"
                        , template.getTableName() + "_TEMP", template.getYear() + "年"));
                List<List<String>> split = CollectionUtil.split(sqlList, 500);
                CompletableFuture<?>[] array = split.stream()
                        .map(list -> CompletableFuture.runAsync(() -> {
                            try {
                                DataSourceService.switchDb(template.getDataSourceId());
                                jdbcTemplate.batchUpdate(ArrayUtil.toArray(list, String.class));
                            }finally {
                                DataSourceService.switchDefault();
                            }
                        }, executor))
                        .toArray(CompletableFuture<?>[]::new);
                CompletableFuture.allOf(array).join();
                //jdbcTemplate.batchUpdate(sqlArr);
                log.info("导入数据用时:[{}]", System.currentTimeMillis() - startTime);
            } catch (Throwable e) {
                log.error("数据导入错误", e);
                throw new BaseException(e.getMessage());
            } finally {
                DataSourceService.switchDefault();
            }

        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }


    /**
     * 获取逻辑校验公式
     *
     * @param leftObjs
     * @param rightObjs
     * @return
     */
    private String getFormula(List<VerifyVO> leftObjs, List<VerifyVO> rightObjs) {
        return leftObjs.stream().map(item -> getValue(item.getCode()) + "（" + getValue(item.getTitle()) + "）")
                .collect(Collectors.joining("+"))
                + " = " +
                rightObjs.stream().map(item -> getValue(item.getCode()) + "（" + getValue(item.getTitle()) + "）")
                        .collect(Collectors.joining("+"));
    }

    public String getValue(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public String resetCoordinate(String coordinate, int index) {
        final String[] coords = coordinate.split(",");
        int columnStart = DiConfig.getIndex(coords[0]);
        return DiConfig.getWord(columnStart + index) + "," + coords[1];
    }

    @SneakyThrows
    public static void main(String[] args) {
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        List<Integer> taskList = Arrays.asList(1, 1, 3, 3, 5, 6, 9, 9, 9, 9);
        CompletableFuture<?>[] array = taskList.stream()
                .map(i -> CompletableFuture.runAsync(() -> {
                    try {
                        TimeUnit.SECONDS.sleep(i);
                    } catch (InterruptedException e) {
                        throw new RuntimeException("休眠异常:"+ i);
                    }
                    System.out.println(StrUtil.format("当前线程:{}:当前数据:{}",Thread.currentThread().getName(),i));
                    if (i == 6){
                        throw new RuntimeException("指定错误:"+ i);
                    }
                }, executorService))
                .toArray(CompletableFuture<?>[]::new);
        CompletableFuture.allOf(array).get();
        System.out.println("结束");
    }
}
