package com.tbyf.his.job.util;

import com.tbyf.his.job.domain.SysJobNew;
import com.tbyf.his.job.obj.JobEnum;
import com.tbyf.his.job.obj.JobExecuteFactory;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobExecutionContext;

/**
 * 定时任务处理（禁止并发执行）
 *
 * @author guopx
 */
@DisallowConcurrentExecution
public class QuartzDisallowConcurrentExecution extends AbstractQuartzJob {
    @Override
    protected void doExecute(JobExecutionContext context, SysJobNew sysJob) throws Exception {
        JobEnum jobEnum = JobEnum.getByType(Integer.parseInt(sysJob.getType()));
        JobExecuteFactory.getJobExecute(jobEnum).execute(sysJob);
    }
}
